% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombine_combine.R
\name{combDdf}
\alias{combDdf}
\title{"DDF" Recombination}
\usage{
combDdf(...)
}
\arguments{
\item{\ldots}{additional attributes to define the combiner (currently only used internally)}
}
\description{
"DDF" recombination - results into a "ddf" object, rbinding if necessary
}
\details{
\code{combDdf} is passed to the argument \code{combine} in \code{\link{recombine}}.

If the \code{value} of the "ddo" object that will be recombined is a list, then the elements in the list will be
collapsed together via \code{\link{rbind}}.
}
\examples{
# Divide the iris data
bySpecies <- divide(iris, by = "Species")

## Simple combination to form a ddf
##---------------------------------------------------------

# Add a transform that selects the petal width and length variables
selVars <- function(x) x[,c("Petal.Width", "Petal.Length")]

# Apply the transform and combine using combDdo
combined <- recombine(addTransform(bySpecies, selVars), combine = combDdf)
combined
combined[[1]]

# A more concise (and readable) way to do it
bySpecies \%>\%
  addTransform(selVars) \%>\%
  recombine(combDdf)

## Combination that involves rbinding to give the ddf
##---------------------------------------------------------

# A transformation that returns a list
listTrans <- function(x) {
  list(meanPetalWidth = mean(x$Petal.Width),
       maxPetalLength = max(x$Petal.Length))
}

# Apply the transformation and look at the result
bySpeciesTran <- addTransform(bySpecies, listTrans)
bySpeciesTran[[1]]

# And if we rbind the "value" of the first subset:
out1 <- rbind(bySpeciesTran[[1]]$value)
out1

# Note how the combDdf method row binds the two data frames
combined <- recombine(bySpeciesTran, combine = combDdf)
out2 <- combined[[1]]
out2

# These are equivalent
identical(out1, out2$value)

}
\author{
Ryan Hafen
}
\seealso{
\code{\link{divide}}, \code{\link{recombine}}, \code{\link{combCollect}}, \code{\link{combMeanCoef}}, \code{\link{combRbind}}, \code{\link{combDdo}}, \code{\link{combDdf}}
}

