% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validator.R
\name{dte_vec}
\alias{dte_vec}
\title{Validator: Check if element is a date}
\usage{
dte_vec(
  max_len = Inf,
  min_len = 1,
  level = "error",
  allow_na = FALSE,
  allow_dups = TRUE
)
}
\arguments{
\item{max_len}{The maximum length of a date element}

\item{min_len}{The minimum length of a date element}

\item{level}{Setting "warn" throws a warning, setting "error" halts}

\item{allow_na}{Should NA values be allowed?}

\item{allow_dups}{Should duplicates be allowed?}
}
\value{
A function with the following properties:
\itemize{
\item Checks whether something is a date
\item Determines whether the check will throw warning or error
\item Optionally checks for element length
}
}
\description{
This function is used to check whether something is a date. You can use this
function to check the length of a date vector. You can also specify the level
of a violation. If level is set to "warn" then invalid inputs will warn you.
However, if level is set to "error" then invalid inputs will abort.
}
\examples{
# Define a dataclass for testing dates:
my_dataclass <-
  dataclass(
    num_val = num_vec(),
    # Setting warn means a warning will occur if violation is found
    # The default is "error" which is stricter and will halt upon violation
    dte_val = dte_vec(level = "warn")
  )

# While `num_val` must be a number, `dte_val` must be a date!
my_dataclass(
  num_val = c(1, 2, 3),
  dte_val = Sys.Date()
)

my_dataclass(
  num_val = c(1, 2, 3),
  dte_val = as.Date("2022-01-01")
)

my_dataclass(
  num_val = c(1, 2, 3),
  dte_val = as.Date(c("2022-01-01", "2023-01-01"))
)
}
