% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastFunctions.r
\name{fastRound}
\alias{fastRound}
\title{Fast round}
\usage{
fastRound(dataSet, cols = "auto", digits = 2, verbose = TRUE)
}
\arguments{
\item{dataSet}{matrix, data.frame or data.table}

\item{cols}{List of numeric column(s) name(s) of dataSet to transform. To transform all 
numerics columns, set it to "auto" (characters, default to "auto")}

\item{digits}{The number of digits after comma (numeric, default to 2)}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\value{
The same datasets but as a data.table and with numeric rounded.
}
\description{
Fast round of numeric columns in a data.table. Will only round numeric, so don't worry about characters. 
Also, it computes it column by column so your RAM is safe too.
}
\details{
It is performing round by \strong{reference} on dataSet, column by column, only on numercial columns. 
So that it avoid copying dataSet in RAM.
}
\examples{
# First let's build a very large data.table with random numbers
require(data.table)
M <- as.data.table(matrix(runif (3e4), ncol = 10))

M_rouded <- fastRound(M, 2)
# Lets add some character
M[, stringColumn := "a string"] 

# And use our function
M_rouded <- fastRound(M, 2)
# It still work :) and you don't have to worry about the string.
}
