% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centralValue.R
\name{centralValue}
\alias{centralValue}
\title{summaryFunction for central values}
\usage{
centralValue(v, ...)
}
\arguments{
\item{v}{A variable (vector).}

\item{...}{Extra arguments to be passed to class-specific functions. These incluse
\code{maxDecimals} (default is 2) which controls the rounding of integer and numeric
values.}
}
\value{
An object of class \code{summaryResult} with the following entries: \code{$feature} 
(the mode/median),\code{$result} (the central value of \code{v}) and \code{$value} (identical 
to \code{$result}).

If the mode is returned and it is not uniquely determined, the first value qualifying as a mode is
returned, when the variable is sorted according to \code{\link{sort}}.
}
\description{
A \code{summaryFunction}, intended to be called from 
\code{\link{summarize}}, which returns the central value of a variable. 
For numeric and integer variables, this is the median. For
character, factor, (have_)labelled, Date and logical variables, the central value is the mode 
(i.e. the value that occurs the largest number of times).
}
\details{
Note that NA, NaN and Inf values are ignored for numeric and integer variables, while
only NA values are ignored for factor, character, Date and (haven_)labelled variables. No values are
ignored for logical variables.
}
\examples{
 #central value of an integer variable:
   centralValue(c(rep(1, 25), rep(2, 10), rep(3, 20)))

 #central value of a character variable:
   centralValue(as.character(c(rep(1, 20), rep(2, 10), rep(3, 20))))

}
\seealso{
\code{\link{summaryFunction}}, \code{\link{summarize}}, \code{\link{summaryResult}},
\code{\link{allSummaryFunctions}}
}
