% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setSummaries.R
\name{setSummaries}
\alias{setSummaries}
\title{Set summary arguments for makeDataReport}
\usage{
setSummaries(character = defaultCharacterSummaries(),
  factor = defaultFactorSummaries(), labelled = defaultLabelledSummaries(),
  numeric = defaultNumericSummaries(), integer = defaultIntegerSummaries(),
  logical = defaultLogicalSummaries(), Date = defaultDateSummaries(),
  all = NULL)
}
\arguments{
\item{character}{A character vector of function names to be used as summaries for character
variables. The default options are available by calling \code{defaultCharacterSummaries()}.}

\item{factor}{A character vector of function names to be used as summaries for factor
variables. The default options are available by calling \code{defaultFactorSummaries()}.}

\item{labelled}{A character vector of function names to be used as summaries for labelled
variables. The default options are available by calling \code{defaultLabelledSummaries()}.}

\item{numeric}{A character vector of function names to be used as summaries for numeric
variables. The default options are available by calling \code{defaultNumericSummaries()}.}

\item{integer}{A character vector of function names to be used as summaries for integer
variables. The default options are available by calling \code{defaultIntegerSummaries()}.}

\item{logical}{A character vector of function names to be used as summaries for logical
variables. The default options are available by calling \code{defaultLogicalSummaries()}.}

\item{Date}{A character vector of function names to be used as summaries for Date
variables. The default options are available by calling \code{defaultDateSummaries()}.}

\item{all}{A character vector of function names to be used as summaries for all
variables. Note that this overrules the choices made for specific variable types by using
the other arguments.}
}
\value{
A list with one entry for each data class supported by \code{makeDataReport}. Each
entry then contains a character vector of function names that are to be called as summaries for
that variable type.
}
\description{
This function is a tool for easily specifying the \code{summaries} argument of 
\code{\link{makeDataReport}}. Note that all available summary function options can be inspected
by calling \code{allSummaryFunctions()}.
}
\examples{
#Don't include central value (median/mode) summary for numerical and integer
#variables:
  setSummaries(numeric = defaultNumericSummaries(remove = "centralValue"),
    integer = defaultIntegerSummaries(remove = "centralValue"))
  
     
#Used in a call to makeDataReport():
\dontrun{
data(toyData)
makeDataReport(toyData, 
  setSummaries(numeric = defaultNumericSummaries(remove = "centralValue"),
    integer = defaultIntegerSummaries(remove = "centralValue")), replace = TRUE)
}
     
}
\seealso{
\code{\link{makeDataReport}}, \code{\link{allSummaryFunctions}},
\code{\link{defaultCharacterSummaries}}, 
\code{\link{defaultFactorSummaries}}, \code{\link{defaultLabelledSummaries}},
\code{\link{defaultNumericSummaries}}, \code{\link{defaultIntegerSummaries}},
\code{\link{defaultLogicalSummaries}}, \code{\link{defaultDateSummaries}}
}
