% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize}
\alias{summarize}
\title{Make summary matrix}
\usage{
summarize(v, ...)
}
\arguments{
\item{v}{The variable (vector) or dataset (data.frame) to be summarized.}

\item{...}{Additional argument passed to data class specific methods. First and foremost,
this is where to supply the summary functions (see details).}
}
\value{
If \code{v} is a single variable: A matrix with two columns, \code{feature} and 
\code{result} and one row for each summary function that was called. Character
strings in this matrix are escaped such that they are ready for Rmarkdown rendering.

If \code{v} is a full dataset: A list of matrices as described above, one for each
variable in the dataset.
}
\description{
Generic shell function that produces a summary matrix for a variable (or for each
variable in an entire dataset), given a number of summary functions and 
depending on its data class.
}
\details{
Summary functions are supplied using their
names (in character strings) in the class-specific argument, e.g.
\code{characterSummaries = c("countMissing", "uniqueValues")} for character variables and
similarly for the remaining 6 data classes (factor, Date, labelled, numeric, integer, logical).
Note that an overview of all available \code{summaryFunction}s can be obtained by calling
\code{\link{allSummaryFunctions}}. 

The default choices of \code{summaryFunctions} are available in data class specific functions, e.g.
\code{defaultCharacterSummaries()} and \code{defaultNumericSummaries()}.

A user defined summary function can be supplied using its function name. Note
however that it should take a vector as argument and return a list on the form
\code{list(feature="Feature name", result="The result")}. More details on how to construct 
valid summary functions are found in \code{\link{summaryFunction}}.
}
\examples{
#Default summary for a character vector:
   charV <- c("a", "b", "c", "a", "a", NA, "b", "0")
   summarize(charV)

#Inspect default character summary functions:
   defaultCharacterSummaries()

#Define a new summary function and add it to the summary for character vectors:
   countZeros <- function(v, ...) {
     res <- length(which(v == 0))
     summaryResult(list(feature="No. zeros", result = res, value = res))
   }
   summarize(charV, characterSummaries = c(defaultCharacterSummaries(), "countZeros"))

 #Does nothing, as intV is not affected by characterSummaries
   intV <- c(0:10)
   summarize(intV, characterSummaries = c(defaultCharacterSummaries(), "countZeros"))

 #But supplying the argument for integer variables changes the summary:
   summarize(intV, integerSummaries = "countZeros")
   
 #Summarize a full dataset:
  data(cars)
  summarize(cars)

}
\seealso{
\code{\link{summaryFunction}}, \code{\link{allSummaryFunctions}}, 
\code{\link{defaultCharacterSummaries}}, \code{\link{defaultFactorSummaries}},
\code{\link{defaultLabelledSummaries}}, \code{\link{defaultLabelledSummaries}},
\code{\link{defaultNumericSummaries}}, \code{\link{defaultIntegerSummaries}},
\code{\link{defaultLogicalSummaries}}
}
