% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/node.R
\name{as.data.frame.Node}
\alias{as.data.frame.Node}
\title{Convert a \code{\link{Node}} to a \code{data.frame}}
\usage{
\method{as.data.frame}{Node}(x, row.names = NULL, optional = FALSE, ...,
  filterFun = function(x) TRUE)
}
\arguments{
\item{x}{The root node to convert to a data.frame}

\item{row.names}{\code{NULL} or a character vector giving the row names for the data frame.
Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and converting column names
(to syntactic names: see make.names) is optional.}

\item{...}{the attributes to be added as columns of the data.frame. There are various
options:
\itemize{
 \item a string corresponding to the name of a node attribute
 \item the result of the \code{Node$Get} method
}
If a specific Node does not contain the attribute, \code{NA} is added to the data.frame.}

\item{filterFun}{a function which filters the Nodes added to the \code{data.frame}. The function must
take a \code{Node} as an input, and it must return \code{TRUE} or \code{FALSE}, depending on whether the
\code{Node} and its subtree should be displayed.}
}
\description{
Convert a \code{\link{Node}} to a \code{data.frame}
}

