% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/node.R
\name{Sort}
\alias{Sort}
\title{Sort Children of a Node or an Entire Tree}
\usage{
Sort(attribute, ..., decreasing = FALSE, recursive = TRUE)
}
\arguments{
\item{attribute}{a field, method or function. The result of the attribute determines the
sorting. If it is a function, #' the attribute must take a \code{Node} as a first argument.}

\item{...}{any parameters to be passed on the the attribute (in case it's a method or a
function)}

\item{decreasing}{sort order}

\item{recursive}{if \code{TRUE}, Sort will be called recursively on the \code{Node}'s children.
This allows sorting an entire tree.}
}
\description{
You can sort with respect to any argument of the tree.
}
\examples{
data(acme)
acme$Get("Aggregate", "cost", sum, assign = "totalCost")
acme$Sort("totalCost", decreasing = TRUE)
print(acme, "totalCost")
}
\seealso{
\code{\link{Node}}
}
\keyword{internal}

