import pytest
from dash_core_components_page import DashCoreComponentsMixin
from dash.testing.browser import Browser


class DashCoreComponentsComposite(Browser, DashCoreComponentsMixin):
    def __init__(self, server, **kwargs):
        super(DashCoreComponentsComposite, self).__init__(**kwargs)
        self.server = server

    def start_server(self, app, **kwargs):
        """start the local server with app"""

        # start server with app and pass Dash arguments
        self.server(app, **kwargs)

        # set the default server_url, it implicitly call wait_for_page
        self.server_url = self.server.url


@pytest.fixture
def dash_dcc(request, dash_thread_server, tmpdir):
    with DashCoreComponentsComposite(
        dash_thread_server,
        browser=request.config.getoption("webdriver"),
        remote=request.config.getoption("remote"),
        remote_url=request.config.getoption("remote_url"),
        headless=request.config.getoption("headless"),
        options=request.config.hook.pytest_setup_options(),
        download_path=tmpdir.mkdir("download").strpath,
        percy_assets_root=request.config.getoption("percy_assets"),
        percy_finalize=request.config.getoption("nopercyfinalize"),
        pause=request.config.getoption("pause"),
    ) as dc:
        yield dc
