% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.load.r
\name{gl.load}
\alias{gl.load}
\title{Retrieves an object in compressed binary format earlier saved using gl.save.}
\usage{
gl.load(file, verbose = NULL)
}
\arguments{
\item{file}{-- name of the binary file from which to retrieve the object [required]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
the retrieved object
}
\description{
This is a wrapper for readRDS().
}
\details{
The script retrieves the object from the current workspace and returns it by assignment.
}
\examples{
gl.save(testset.gl,file.path(tempdir(),"testset.rds"))
gl.reloaded <- gl.load(file.path(tempdir(),"testset.rds"))
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
