% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.gene.freq.r
\name{gl.gene.freq}
\alias{gl.gene.freq}
\title{Calculate a statistic for each locus by group
 
 An internal function essentially to convey readability to rather contorted R code.
 It takes as input a genlight \{adegenet\} object with an index variable (say, population)
 and calculates the selected statistic for each locus, broken down by the groups defined
 by the index variable.}
\usage{
gl.gene.freq(gl, method = pop(gl), stat = "mean")
}
\arguments{
\item{gl}{-- name of the genlight object containing the SNP data [required]}

\item{method}{-- breakdown variable [default pop(x)]}

\item{stat}{-- statistic to calculate: mean [only mean(x)/2 currently implemented]}
}
\value{
A matrix, populations (rows) by loci (columns), showing the statistic [mean/2]
}
\description{
Calculate a statistic for each locus by group
 
 An internal function essentially to convey readability to rather contorted R code.
 It takes as input a genlight \{adegenet\} object with an index variable (say, population)
 and calculates the selected statistic for each locus, broken down by the groups defined
 by the index variable.
}
\examples{
#result <- gl.gene.freq(testset.gl, method=pop(gl), stat="mean")
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
