% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.RepAvg.r
\name{gl.filter.RepAvg}
\alias{gl.filter.RepAvg}
\title{Filter loci in a genlight \{adegenet\} object based on average repeatability of alleles at a locus}
\usage{
gl.filter.RepAvg(x, threshold = 0.99, verbose = NULL)
}
\arguments{
\item{x}{-- name of the genlight object containing the SNP data [required]}

\item{threshold}{-- threshold value below which loci will be removed [default 0.99]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2, unless specified using gl.set.verbosity]}
}
\value{
Returns a genlight object retaining loci with repeatability (Repavg or Reproducibility) greater than the specified threshold.
}
\description{
SNP datasets generated by DArT have an index, RepAvg, generated by reproducing the data independently for 30% of loci.
RepAvg is the proportion of alleles that give a repeatable result, averaged over both alleles for each locus.
}
\details{
SilicoDArT datasets generated by DArT have a smilar index, Reproducibility. For these fragment presence/absence data, repeatability is the 
percentage of scores that are repeated in the technical replicate dataset.
}
\examples{
# SNP data
  gl.report.reproducibility(testset.gl)
  result <- gl.filter.reproducibility(testset.gl, threshold=0.99, verbose=3)
# Tag P/A data
  gl.report.reproducibility(testset.gs)
  result <- gl.filter.reproducibility(testset.gs, threshold=0.99)
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
