% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.pval.r
\name{gl.collapse.pval}
\alias{gl.collapse.pval}
\title{Collapse a fixed distance matrix by amalgamating populations for which fixed differences are not significant}
\usage{
gl.collapse.pval(fd, prefix = "fd.sig", delta = 0.02, reps = 1000,
  alpha = 0.05, v = 2)
}
\arguments{
\item{fd}{-- name of the list of matricies output by gl.collapse.recursive run with test=TRUE [required]}

\item{prefix}{-- a string to be used as a prefix in generating the matrix of fixed differences (stored to disk) and the recode
table (also stored to disk) [default "fd_sig"]}

\item{delta}{Default 0.02}

\item{reps}{number of repetition. Default 1000.}

\item{alpha}{-- significance level for test of false positives [default 0.05]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A list containing the gl object x and the following square matricies
        [[1]] $gl -- the input genlight object;
        [[2]] $fd -- raw fixed differences;
        [[3]] $pcfd -- percent fixed differences;
        [[4]] $nobs -- mean no. of individuals used in each comparison;
        [[5]] $nloc -- total number of loci used in each comparison;
        [[6]] $expobs -- if test=TRUE, the expected count of false positives for each comparison [by simulation], otherwise NAs
        [[7]] $prob -- if test=TRUE, the significance of the count of fixed differences [by simulation], otherwise NAs
}
\description{
This script takes the output from gl.collapse recursive and further collapses the fixed difference matrix
based on the pvalue associated with each comparison. The results are subsets of populations (OTUs) for which
diagnosability is non-significant. A recode table is generated applied to the genlight object to reflect 
the resultant OTUs.
}
\details{
The recode table and final distance matrix are stored to disk as csv files.
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
