% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.recode.ind.r
\name{gl.recode.ind}
\alias{gl.recode.ind}
\title{Recode individual (=specimen) labels in a genelight or genind object \{adegenet\}}
\usage{
gl.recode.ind(gl, ind.recode)
}
\arguments{
\item{gl}{-- name of the genlight object containing SNP genotypes or a genind object containing presence/absence data [required]}

\item{ind.recode}{-- name of the csv file containing the individual relabelling [required]}
}
\value{
A genlight or genind object with the recoded and reduced data
}
\description{
This script recodes individual labels and/or deletes individuals from a DaRT genlight SNP file or a SilicoDArT genind file
based on information provided in a csv file.
}
\details{
Renaming individuals may be required when there have been errors in labelling arising
in the process from sample to DArT files. There may be occasions where renaming
individuals is required for preparation of figures. Caution needs to be exercised
because of the potential for breaking the "chain of evidence" between the samples themselves
and the analyses. Recoding individuals can be done with a recode table (csv).

The script, having deleted individuals, identifies resultant monomorphic loci or loci
with all values missing and deletes them (using gl.filter.monomorphs.r)
}
\examples{
\dontrun{
   gl <- gl.recode.ind(testset.gl, ind.recode="testset_pop_recode.csv")
}
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
\seealso{
\code{\link{gl.filter.monomorphs}}
}

