% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{isAdjustmentSet}
\alias{isAdjustmentSet}
\title{Adjustment Criterion}
\usage{
isAdjustmentSet(x, Z, exposure = NULL, outcome = NULL)
}
\arguments{
\item{x}{the input graph, a DAG, MAG, PDAG, or PAG.}

\item{Z}{vector of variable names.}

\item{exposure}{name(s) of the exposure variable(s). If not given (default), then the 
exposure variables are supposed to be defined in the graph itself.}

\item{outcome}{name(s) of the outcome variable(s), also taken from the graph if 
not given.}
}
\description{
Test whether a set fulfills the adjustment criterion, that means,
it removes all confounding bias when estimating a *total* effect.
This is an #' Back-door criterion (Shpitser et al, 2010; van der Zander et al, 
2014; Perkovic et al, 2015) 
which is complete in the sense that either a set
fulfills this criterion, or it does not remove all confounding bias.
}
\details{
If the input graph is a MAG or PAG, then it must not contain any undirected
edges (=hidden selection variables).
}
\references{
E. Perkovic, J. Textor, M. Kalisch and M. H. Maathuis (2015), A
Complete Generalized Adjustment Criterion. In \emph{Proceedings of UAI
2015.}

I. Shpitser, T. VanderWeele and J. M. Robins (2010), On the
validity of covariate adjustment for estimating causal effects. In
\emph{Proceedings of UAI 2010.}
}
