% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dagitty.r
\name{isAcyclic}
\alias{isAcyclic}
\title{Test for Cycles}
\usage{
isAcyclic(x)
}
\arguments{
\item{x}{the input graph, of any graph type.}
}
\description{
Returns \code{TRUE} if the given graph does not contain a directed cycle.
}
\details{
This function will only consider simple directed edges in the
given graph.
}
\examples{
g1 <- dagitty("dag{X -> Y -> Z}")
stopifnot( isTRUE(isAcyclic( g1 )) )
g2 <- dagitty("dag{X -> Y -> Z -> X}")
stopifnot( isTRUE(!isAcyclic( g2 )) )
g3 <- dagitty("mag{X -- Y -- Z -- X}")
stopifnot( isTRUE(isAcyclic( g3 )) )
}
