% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R
\name{conds}
\alias{conds}
\alias{conds.drift_dm}
\alias{conds.fits_ids_dm}
\alias{conds.data.frame}
\alias{conds.traces_dm_list}
\title{The Conditions of an Object}
\usage{
conds(object, ...)

\method{conds}{drift_dm}(object, ...)

\method{conds}{fits_ids_dm}(object, ...)

\method{conds}{data.frame}(object, ...)

\method{conds}{traces_dm_list}(object, ...)
}
\arguments{
\item{object}{an \code{R} object, see details}

\item{...}{additional arguments.}
}
\value{
\code{NULL} or a character vector with the conditions. \code{NULL} is given if the
object has no conditions (e.g., when a data.frame has no \code{Cond} column).
}
\description{
Extract the conditions from a (supported) object.
}
\details{
\code{conds()} is a generic accessor function. The default methods get the
"conditions" that are present in an object. Currently supported objects:
\itemize{
\item \link{drift_dm}
\item \code{fits_ids_dm} (see \link{load_fits_ids})
\item \link{data.frame}
\item \code{traces_dm_list} (see \link{simulate_traces})
}
}
\note{
There is no respective replacement function for \code{conds()}. If users want to
modify the conditions of a \link{drift_dm} model, they should create a
new \link{flex_prms} object and subsequently set it to the model.
This is because there is no meaningful way to know for the package how the
model shall behave for the newly introduced condition(s).
}
\examples{
# get a pre-built model to demonstrate the conds() function
my_model <- dmc_dm()
conds(my_model)

# accessor functions also work with other object types provided by dRiftDM
# (simulated traces; see the documentation of the respective function)
some_traces <- simulate_traces(my_model, k = 1)
conds(some_traces)

# get an exemplary fits_ids_dm object (see estimate_model_ids)
fits <- get_example_fits_ids()
conds(fits)

# also works with data.frames that have a "Cond" column
conds(dmc_synth_data)

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
