% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{odemodel}
\alias{odemodel}
\title{Generate the model objects for use in Xs (models with sensitivities)}
\usage{
odemodel(
  f,
  deriv = TRUE,
  forcings = NULL,
  events = NULL,
  outputs = NULL,
  fixed = NULL,
  estimate = NULL,
  modelname = "odemodel",
  solver = c("deSolve", "Sundials"),
  gridpoints = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{f}{Something that can be converted to \link{eqnvec},
e.g. a named character vector with the ODE}

\item{deriv}{logical, generate sensitivities or not}

\item{forcings}{Character vector with the names of the forcings}

\item{events}{data.frame of events with columns "var" (character, the name of the state to be
affected), "time" (character or numeric, time point), "value" (character or numeric, value),
"method" (character, either
"replace" or "add"). See \link[deSolve]{events}. Events need to be defined here if they contain
parameters, like the event time or value. If both, time and value are purely numeric, they
can be specified in \code{\link{Xs}()}, too.}

\item{outputs}{Named character vector for additional output variables.}

\item{fixed}{Character vector with the names of parameters (initial values and dynamic) for which
no sensitivities are required (will speed up the integration).}

\item{estimate}{Character vector specifying parameters (initial values and dynamic) for which
sensitivities are returned. If estimate is specified, it overwrites `fixed`.}

\item{modelname}{Character, the name of the C file being generated.}

\item{solver}{Solver for which the equations are prepared.}

\item{gridpoints}{Integer, the minimum number of time points where the ODE is evaluated internally}

\item{verbose}{Print compiler output to R command line.}

\item{...}{Further arguments being passed to funC.}
}
\value{
list with \code{func} (ODE object) and \code{extended} (ODE+Sensitivities object)
}
\description{
Generate the model objects for use in Xs (models with sensitivities)
}
\examples{
\dontrun{

## Generate a compiled ODE model from an equation vector
## The model will not return sensitivities for "switch"
## Files will be generated in your working directory!

f <- eqnvec(A = "-k*A + switch*F")
model <- odemodel(f, forcings = "F", fixed = "switch")
print(model)

## Generate the same model from an equation list
f <- addReaction(NULL, from = "", to = "A", rate = "switch*F", description = "production")
f <- addReaction(f   , from = "A", to = "", rate = "k*A", description = "degradation")
print(f)

model <- odemodel(f, forcings = "F", fixed = "switch")
print(model)


# create forcings
forc1 <- data.frame(name = "F", time = seq(0,5, 0.1), value = sin(seq(0,5,0.1)))
forc2 <- data.frame(name = "F", time = seq(0,5, 0.1), value = exp(-seq(0,5,0.1)))
forc3 <- data.frame(name = "F", time= 0,              value = 0.1)


x <- Xs(model, forc1, condition = "forc1") + 
  Xs(model, forc2, condition = "forc2") + 
  Xs(model, forc3, condition = "forc3")

g <- Y(c(out1 = "F * A", out2 = "F"), x)

times <-  seq(0,5, 0.001)
pars <- setNames(runif(length(getParameters(x))), getParameters(x))

pred <- (g*x)(times, pars)  
plot(pred)


}
}
