% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steadyStates.R
\name{steadyStates}
\alias{steadyStates}
\title{Calculate analytical steady states.}
\usage{
steadyStates(model, file = NULL, smatrix = NULL, states = NULL,
  rates = NULL, forcings = NULL, givenCQs = NULL, neglect = NULL,
  sparsifyLevel = 2, outputFormat = "R")
}
\arguments{
\item{model}{Either name of the csv-file or the eqnlist of the model. If NULL, specify smatrix, states and rates by hand.}

\item{file}{Name of the file to which the steady-state equations are saved.
Read this file with \code{\link{readRDS}}.}

\item{smatrix}{Numeric matrix, stiochiometry matrix of the system}

\item{states}{Character vector, state vector of the system}

\item{rates}{Character vector, flux vector of the system}

\item{forcings}{Character vector with the names of the forcings}

\item{givenCQs}{Character vector with conserved quantities. Use the format c("A + pA = totA", "B + pB = totB"). If NULL, conserved quantities are automatically calculated.}

\item{neglect}{Character vector with names of states and parameters that must not be used for solving the steady-state equations}

\item{sparsifyLevel}{numeric, Upper bound for length of linear combinations used for simplifying the stoichiometric matrix}

\item{outputFormat}{Define the output format. By default "R" generating dMod 
compatible output. To obtain an output appropriate for d2d [2] "M" must be 
selected.}
}
\value{
Character vector of steady-state equations.
}
\description{
This function follows the method published in [1]. The determined steady-state solution is tailored to parameter estimation. Please note that kinetic parameters might be fixed for solution of steady-state equations. Note that additional parameters might be introduced to ensure positivity of the solution.

The function calls a python script via rPython. Usage problems might occur when different python versions are used. The script was written and tested for python 2.7.12, sympy 0.7.6 and numpy 1.8.2.

Recently, users went into problems with RJSONIO when rPython was used. Unless a sound solution is available, please try to reinstall RJSONIO in these cases.
}
\examples{
\dontrun{
reactions <- eqnlist()
reactions <- addReaction(reactions, "Tca_buffer", "Tca_cyto", 
                         "import_Tca*Tca_buffer", "Basolateral uptake")
reactions <- addReaction(reactions, "Tca_cyto", "Tca_buffer", 
                         "export_Tca_baso*Tca_cyto", "Basolateral efflux")
reactions <- addReaction(reactions, "Tca_cyto", "Tca_canalicular", 
                         "export_Tca_cana*Tca_cyto", "Canalicular efflux")
reactions <- addReaction(reactions, "Tca_canalicular", "Tca_buffer", 
                         "transport_Tca*Tca_canalicular", "Transport bile")

mysteadies <- steadyStates(reactions)
print(mysteadies)
}
}
\references{
[1]
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4863410/}

[2]
\url{https://github.com/Data2Dynamics/d2d}
}
\author{
Marcus Rosenblatt, \email{marcus.rosenblatt@fdm.uni-freiburg.de}
}
