% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dGAselID.R
\name{EvaluationFunction}
\alias{EvaluationFunction}
\title{EvaluationFunction}
\usage{
EvaluationFunction(x, individuals, response, method, trainTest, nnetSize = NA,
  nnetDecay = NA, rdaAlpha = NA, rdaDelta = NA, ...)
}
\arguments{
\item{x}{Dataset in ExpressionSet format.}

\item{individuals}{Population of individuals with diploid genotypes.}

\item{response}{Response variable.}

\item{method}{Supervised classifier for fitness evaluation. Most of the supervised classifiers in MLInterfaces are acceptable. The default is knn.cvI(k=3, l=2).}

\item{trainTest}{Cross-validation method. The default is "LOG".}

\item{nnetSize}{for nnetI. The default value is NA.}

\item{nnetDecay}{for nnetI. The default value is NA.}

\item{rdaAlpha}{for rdaI. The default value is NA.}

\item{rdaDelta}{for rdaI. The default value is NA.}

\item{...}{Additional arguments.}
}
\description{
Evaluates the individuals' fitnesses.
}
\examples{
\dontrun{
 library(genefilter)
 library(ALL)
 data(ALL)
 bALL = ALL[, substr(ALL$BT,1,1) == "B"]
 smallALL = bALL[, bALL$mol.biol \%in\% c("BCR/ABL", "NEG")]
 smallALL$mol.biol = factor(smallALL$mol.biol)
 smallALL$BT = factor(smallALL$BT)
 f1 <- pOverA(0.25, log2(100))
 f2 <- function(x) (IQR(x) > 0.5)
 f3 <- ttest(smallALL$mol.biol, p=0.1)
 ff <- filterfun(f1, f2, f3)
 selectedsmallALL <- genefilter(exprs(smallALL), ff)
 smallALL = smallALL[selectedsmallALL, ]
 rm(f1)
 rm(f2)
 rm(f3)
 rm(ff)
 rm(bALL)
 sum(selectedsmallALL)
 set.seed(1357)

 population0<-InitialPopulation(smallALL, 14, 8, FALSE)
 individuals0<-Individuals(population0)
 results<-EvaluationFunction(smallALL, individuals0, response="mol.biol",
             method=knn.cvI(k=3, l=2), trainTest="LOG")
 }
}

