% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{czso_get_codelist}
\alias{czso_get_codelist}
\title{Get CZSO codelist (registry / číselník)}
\usage{
czso_get_codelist(
  codelist_id,
  language = c("cs", "en"),
  dest_dir = NULL,
  resource_num = NULL,
  force_redownload = F
)
}
\arguments{
\item{codelist_id}{character or numeric of length 1 or 2; ID of codelist to download. See Details.}

\item{language}{language, either "cs" (the default) or "en", which is available for some codelists.}

\item{dest_dir}{character. Directory in which downloaded files will be stored.
If left unset, will use the \code{czso.dest_dir} option if the option is set, and \code{tempdir()} otherwise. Will be created if it does not exist.}

\item{resource_num}{integer, order of resource. Only override if you need a different format.}

\item{force_redownload}{whether to download even if a cached local file is available.}
}
\value{
a \link[tibble:tibble-package]{tibble} All columns except dates kept as character.
See Details for the columns.
}
\description{
Downloads codelist (registry table) and returns it in a tibble.
Codelists are canonical lists of entities, their names and IDs. See Details.
Codelists are included in catalogue which can be retrieved using \code{czso_get_catalogue()}.
Their IDs start with \code{"cis"} followed by a two- to three-digit number.
}
\details{
\subsection{Codelists}{

Codelists are canonical registries of entities:
things, statistical areas and aggregates, concepts, categorisations.
A codelist typically contains IDs and names of all the entities fitting into
a certain category.

The most commonly used codelists are geographical, e.g. lists of regions or
municipalities.

In the world of the CZSO, each codelist has a numeric ID of two to four digits.
You can pass this number to the function (even as a string), or you can pass the dataset ID found
in the catalogue; the latter will have the form of e.g. \code{"cisNN"}.
\subsection{Relationships between codelists ("vazba mezi číselníky")}{

The CZSO data store also holds tables describing relations between codelists.
This is especially useful for spatial hierarchies (e.g. which towns belong to which region), or for converting
between categorisations (e.g. two different sets of IDs for regions.)

You can pass a vector of two IDs (numeric or character) and if the relational
table for these two exists, it will be returned. (If it does not work,
try flipping them around). The equivalent dataset ID, as found in the catalogue,
is \code{"cisXXvazYY"}.
}

}

\subsection{Columns in output}{

For single-codelist files, see below for the most commonly included columns.
For relational tables, you will see each column twice, each time with a suffix of 1 or 2.
\itemize{
\item AKRCIS: codelist abbreviation
\item KODCIS: codelist ID
\item CHODNOTA: entity ID
\item TEXT: entity name
\item ZKRTEXT: entity name abbreviated
\item ADMPLOD: valid from
\item ADMNEPO: invalid after
\item KOD_RUIAN: for geographical entites, RUIAN code (different master registry run by the geodesists)
\item CZNUTS: for geographical entities, NUTS code
}
}
}
\examples{
\donttest{
czso_get_codelist("cis100")

# equivalent
czso_get_codelist(100)

# get a table of relations between two codelists
czso_get_codelist(c(100, 43))

# equivalent
czso_get_codelist("cis100vaz43")
}
}
\seealso{
Other Core workflow: 
\code{\link{czso_get_catalogue}()},
\code{\link{czso_get_table}()},
\code{\link{get_table}()}
}
\concept{Core workflow}
