% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bogons.R
\name{ipv4_bogons}
\alias{ipv4_bogons}
\title{Retrieve list of IPv4 "full bogons" from Team Cymru webservice}
\usage{
ipv4_bogons(force = FALSE, cached_bogons = NA)
}
\arguments{
\item{force}{force a refresh even if the time-frame (4-hours) is not up}

\item{cached_bogons}{if you pass in the previous result of a call to \code{ipv4_bogoons}
it will be returned if the refresh time constraint has not been met, otherwise
\code{NA} will be returned.}
}
\description{
The traditional bogon prefixes (IPV4), plus prefixes that have been allocated to
RIRs but not yet assigned by those RIRs to ISPs, end-users, etc. Updated every four hours.
}
\details{
Bogons are defined as Martians (private and reserved addresses defined by RFC 1918,
RFC 5735, and RFC 6598) and netblocks that have not been allocated to a regional
internet registry (RIR) by the Internet Assigned Numbers Authority.

Fullbogons are a larger set which also includes IP space that has been allocated to
an RIR, but not assigned by that RIR to an actual ISP or other end-user. IANA maintains
a convenient IPv4 summary page listing allocated and reserved netblocks, and each RIR
maintains a list of all prefixes that they have assigned to end-users. Our bogon reference
pages include additional links and resources to assist those who wish to properly filter
bogon prefixes within their networks.
}
\examples{
v4_bogons <- ipv4_bogons()
v4_bogons <- ipv4_bogons(cached_bogons=v4_bogons)
}
\seealso{
\url{http://www.team-cymru.org/bogon-reference-http.html}
}

