% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/journey2.R
\name{journey2}
\alias{journey2}
\title{Plan a journey with CycleStreets.net}
\usage{
journey2(
  fromPlace = NA,
  toPlace = NA,
  id = NULL,
  plan = "fastest",
  pat = NULL,
  base_url = "https://www.cyclestreets.net",
  host_con = 1,
  reporterrors = TRUE,
  segments = FALSE
)
}
\arguments{
\item{fromPlace}{sf points, matrix, or vector of lng/lat coordinates}

\item{toPlace}{sf points, matrix, or vector of lng/lat coordinates}

\item{id}{a character ID value to be attached to the results}

\item{plan}{Text strong of either "fastest" (default), "quietest" or "balanced"}

\item{pat}{The API key used. By default this uses \code{Sys.getenv("CYCLESTREETS")}.}

\item{base_url}{The base url from which to construct API requests
(with default set to main server)}

\item{host_con}{number of threads to use passed to curl::new_pool}

\item{reporterrors}{Boolean value (TRUE/FALSE) indicating if cyclestreets (TRUE by default).
should report errors (FALSE by default).}

\item{segments}{Logical, if true route segments returned otherwise whole routes}
}
\description{
R interface to the CycleStreets.net journey planning API,
a route planner made by cyclists for cyclists.
See \href{https://www.cyclestreets.net/api/}{cyclestreets.net/api} for details.
}
\details{
Requires the internet and a CycleStreets.net API key.
CycleStreets.net does not yet work worldwide.

You need to have an api key for this code to run.
By default it uses the CYCLESTREETS environment variable.
A quick way to set this is to install the \code{usethis} package and then
executing the following command:

\code{usethis::edit_r_environ()}

That should open up a new file in your text editor where you
can add the environment variable as follows
(replace 1a... with your key for this to work):

CYCLESTREETS=1a43ed677e5e6fe9

After setting the environment variable, as outlined above,
you need to restart your R session before the journey function will work.

See \href{https://www.cyclestreets.net/help/journey/howitworks/}{www.cyclestreets.net/help/journey/howitworks/}
for details on how these are calculated.
}
\examples{
\dontrun{
from = c(-1.55, 53.80) # geo_code("leeds")
to = c(-1.76, 53.80) # geo_code("bradford uk")
r1 = journey(from, to)
r2 = journey2(from, to, segments = TRUE)
# waldo::compare(r1, r2) # see differences
sum(sf::st_length(r1))
sum(sf::st_length(r2))
# waldo::compare(sum(sf::st_length(r1)), sum(sf::st_length(r2)))
# waldo::compare(names(r1), names(r2))
# waldo::compare(r1[1, ], r2[1, ])
r1[1:2, ]
r2[1:2, ]
r1$grammesCO2saved
r1$calories
}
}
\seealso{
json2sf_cs
}
