% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs4_nc.R
\name{bs4_nc}
\alias{bs4_nc}
\title{gates out or assign indicators to Synechococcus cyanobacteria cells in the bottom right of the
2-D space.}
\usage{
bs4_nc(bs4bs5, p1, p2, others, to_retain = c("refined", "potential"))
}
\arguments{
\item{bs4bs5}{flowframe with debris (left) removed.}

\item{p1}{first flowcytometer channel that can be used to separate cells of interest
from the rest, e.g. "RED.B.HLin".}

\item{p2}{second flowcytometer channel that can be used to separate cells of interest
from the rest, e.g. "YEL.B.HLin"}

\item{others}{row numbers for non-debris events. This is provided by the
\code{\link{debris_nc}} or \code{\link{debris_inc}} function.}

\item{to_retain}{should potential candidates be retained or further gating be applied
to filter out only certain Synechococcus cyanobacteria cells.}
}
\value{
list containing; \itemize{
\item \strong{syn_reduced -} flowframe containing only Synechococcus cyanobacteria cells
\item \strong{others_nk -} unidentified particle positions
\item \strong{syn_pos -} Synechococcus cyanobacteria cells positions
\item \strong{others_nk2 -} other unidentified particle positions
}
}
\description{
This function takes in a flowframe with debris removed and identifies
             Synechococcus cyanobacteria cell population in the provided frame.
}
\details{
The function uses the \code{\link[flowDensity]{getPeaks}} and
         \code{\link[flowDensity]{deGate}} functions in the \emph{flowDensity} package to
         identify peaks and identify cut-off points between these peaks. This function is
         not designed to be called in isolation, if called in isolation an error will be
         returned. It is preferably called on the results from \code{\link{debris_nc}} or
         \code{\link{debris_inc}} function. A graph with horizontal
         and vertical lines used in separating the populations is returned and
         if \emph{to_retain = "refined"}, a circle made of dashed lines is drawn around
         Synechococcus cyanobacteria cell population points.
}
\seealso{
\code{\link{bs5_nc}}
}
