% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cxr_pm_multifit.R
\name{cxr_pm_multifit}
\alias{cxr_pm_multifit}
\title{Multi-species parameter optimization}
\usage{
cxr_pm_multifit(
  data,
  model_family = c("BH"),
  focal_column = NULL,
  covariates = NULL,
  optimization_method = c("BFGS", "CG", "Nelder-Mead", "ucminf", "L-BFGS-B", "nlm",
    "nlminb", "Rcgmin", "Rvmmin", "spg", "bobyqa", "nmkb", "hjkb", "nloptr_CRS2_LM",
    "nloptr_ISRES", "nloptr_DIRECT_L_RAND", "DEoptimR", "hydroPSO", "GenSA"),
  alpha_form = c("none", "global", "pairwise"),
  lambda_cov_form = c("none", "global"),
  alpha_cov_form = c("none", "global", "pairwise"),
  initial_values = NULL,
  lower_bounds = NULL,
  upper_bounds = NULL,
  fixed_terms = NULL,
  bootstrap_samples = 0
)
}
\arguments{
\item{data}{named list in which each component is
a dataframe with a fitness column and a number of columns representing neighbours}

\item{model_family}{family of model to use. Available families are BH (Beverton-Holt), LV (Lotka-Volterra),
RK (Ricker), and LW (Law-Watkinson). Users may also define their own families and models (see vignette 4).}

\item{focal_column}{character vector with the same length as data,
giving the names of the columns representing
intraspecific observations for each species,
or numeric vector giving the position of such columns.}

\item{covariates}{optional named list in which each component is
a dataframe with values of each covariate for each observation. The ith component
of \code{covariates} are the covariate values that correspond to
the ith component of \code{data}, so they must have the same number of observations.}

\item{optimization_method}{numerical optimization method.}

\item{alpha_form}{what form does the alpha parameter take? one of "none" (no alpha in the model),
"global" (a single alpha for all pairwise interactions), or "pairwise" (one alpha value for every interaction).}

\item{lambda_cov_form}{form of the covariate effects on lambda. Either "none" (no covariate effects) or "global" (one estimate per covariate).}

\item{alpha_cov_form}{form of the covariate effects on alpha. One of "none" (no covariate effects), "global" (one estimate per covariate on every alpha),
or "pairwise" (one estimate per covariate and pairwise alpha)}

\item{initial_values}{list with components "lambda","alpha_intra","alpha_inter","lambda_cov", "alpha_cov", specifying the initial values
for numerical optimization. Single values are allowed.}

\item{lower_bounds}{optional list with single values for "lambda","alpha_intra","alpha_inter","lambda_cov", "alpha_cov".}

\item{upper_bounds}{optional list with single values for "lambda","alpha_intra","alpha_inter","lambda_cov", "alpha_cov".}

\item{fixed_terms}{optional named list in which each component is
itself a list containing fixed terms for each focal species.}

\item{bootstrap_samples}{number of bootstrap samples for error calculation. Defaults to 0, i.e. no error is calculated.}
}
\value{
an object of class 'cxr_pm_multifit' which is a list with the following components:
\itemize{
\item model_name: string with the name of the fitness model
\item model: model function
\item data: data supplied
\item taxa: names of the taxa fitted
\item covariates: covariate data supplied
\item optimization_method: optimization method used
\item initial_values: list with initial values
\item fixed_terms: list with fixed terms
\item lambda: fitted values for lambda, or NULL if fixed
\item alpha_intra: fitted values for alpha_intra, or NULL if fixed
\item alpha_inter: fitted values for alpha_inter, or NULL if fixed
\item lambda_cov: fitted values for lambda_cov, or NULL if fixed
\item alpha_cov: fitted values for alpha_cov, or NULL if fixed
\item lambda_standard_error: standard errors for lambda, if computed
\item alpha_standard_error: standard errors for alpha, if computed
\item lambda_cov_standard_error: standard errors for lambda_cov, if computed
\item alpha_cov_standard_error: standard errors for alpha_cov, if computed
\item log_likelihood: log-likelihoods of the fits
}
}
\description{
This function is a wrapper for estimating parameters for several
focal species, instead of making separate calls to \code{cxr_pm_fit}.
}
\examples{
# fit three species at once
data("neigh_list")
data <- neigh_list[1:3]
# keep only fitness and neighbours columns
for(i in 1:length(data)){
  data[[i]] <- data[[i]][,2:length(data[[i]])]
}
# covariates: salinity
data("salinity_list")
salinity <- salinity_list[1:3]
# keep only salinity column
for(i in 1:length(salinity)){
  salinity[[i]] <- salinity[[i]][,2:length(salinity[[i]])]
}
\donttest{
  fit_3sp <- cxr_pm_multifit(data = data,
                             optimization_method = "bobyqa",
                             model_family = "BH",
                             covariates = salinity,
                             alpha_form = "pairwise",
                             lambda_cov_form = "global",
                             alpha_cov_form = "global",
                             initial_values = list(lambda = 1,
                                                   alpha_intra = 0.1,
                                                   alpha_inter = 0.1,
                                                   lambda_cov = 0.1, 
                                                   alpha_cov = 0.1),
                             lower_bounds = list(lambda = 0.01,
                                                 alpha_intra = 0,
                                                 alpha_inter = 0,
                                                 lambda_cov = 0, 
                                                 alpha_cov = 0),
                             upper_bounds = list(lambda = 100,
                                                 alpha_intra = 1,
                                                 alpha_inter = 1,
                                                 lambda_cov = 1, 
                                                 alpha_cov = 1),
                             bootstrap_samples = 3)
  # brief summary
  summary(fit_3sp)
  # interaction matrix
  fit_3sp$alpha
}
}
