% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline_wrappers.R
\name{baseline_binomial}
\alias{baseline_binomial}
\title{Create baseline evaluations for binary classification}
\usage{
baseline_binomial(
  test_data,
  dependent_col,
  n = 100,
  metrics = list(),
  positive = 2,
  cutoff = 0.5,
  parallel = FALSE
)
}
\arguments{
\item{test_data}{\code{data.frame}.}

\item{dependent_col}{Name of dependent variable in the supplied test and training sets.}

\item{n}{The number of sets of random predictions to evaluate. (Default is \code{100})}

\item{metrics}{\code{list} for enabling/disabling metrics.

  E.g. \code{list("F1" = FALSE)} would remove \code{F1} from the results,
  and \code{list("Accuracy" = TRUE)} would add the regular \code{Accuracy} metric
  to the results.
  Default values (\code{TRUE}/\code{FALSE}) will be used for the remaining available metrics.

  You can enable/disable all metrics at once by including
  \code{"all" = TRUE/FALSE} in the \code{list}. This is done prior to enabling/disabling
  individual metrics, why f.i. \code{list("all" = FALSE, "Accuracy" = TRUE)}
  would return only the \code{Accuracy} metric.

  The \code{list} can be created with
  \code{\link[cvms:binomial_metrics]{binomial_metrics()}}.

  Also accepts the string \code{"all"}.}

\item{positive}{Level from dependent variable to predict.
 Either as character (\emph{preferable}) or level index (\code{1} or \code{2} - alphabetically).

 E.g. if we have the levels \code{"cat"} and \code{"dog"} and we want \code{"dog"} to be the positive class,
 we can either provide \code{"dog"} or \code{2}, as alphabetically, \code{"dog"} comes after \code{"cat"}.

 \strong{Note:} For \emph{reproducibility}, it's preferable to \strong{specify the name directly}, as
 different \code{\link[base:locales]{locales}} may sort the levels differently.

 Used when calculating confusion matrix metrics and creating \code{ROC} curves.

 N.B. Only affects evaluation metrics, not the returned predictions.}

\item{cutoff}{Threshold for predicted classes. (Numeric)}

\item{parallel}{Whether to run the \code{`n`} evaluations in parallel. (Logical)

 Remember to register a parallel backend first.
 E.g. with \code{doParallel::registerDoParallel}.}
}
\value{
\code{list} containing:

 \enumerate{
  \item a \code{tibble} with summarized results (called \code{summarized_metrics})
  \item a \code{tibble} with random evaluations (\code{random_evaluations})
 }

 ....................................................................

 Based on the generated test set predictions,
 a confusion matrix and \code{ROC} curve are used to get the following:

 \code{ROC}:

 \strong{\code{AUC}}, \strong{\code{Lower CI}}, and \strong{\code{Upper CI}}

 Note, that the \code{ROC} curve is only computed when \code{AUC} is enabled.

 \code{Confusion Matrix}:

 \strong{\code{Balanced Accuracy}},
 \strong{\code{Accuracy}},
 \strong{\code{F1}},
 \strong{\code{Sensitivity}}, \strong{\code{Specificity}},
 \strong{\code{Positive Predictive Value}},
 \strong{\code{Negative Predictive Value}},
 \strong{\code{Kappa}},
 \strong{\code{Detection Rate}},
 \strong{\code{Detection Prevalence}},
 \strong{\code{Prevalence}}, and
 \strong{\code{MCC}} (Matthews correlation coefficient).

 ....................................................................

 The \strong{Summarized Results} \code{tibble} contains:

 The \strong{Measure} column indicates the statistical descriptor used on the evaluations.
 The row where \code{Measure == All_0} is the evaluation when all predictions are \code{0}.
 The row where \code{Measure == All_1} is the evaluation when all predictions are \code{1}.

 The \strong{aggregated metrics}.

 ....................................................................

 The \strong{Random Evaluations} \code{tibble} contains:

 The \strong{non-aggregated metrics}.

 A nested \code{tibble} with the \strong{predictions} and targets.

 A \code{list} of \strong{ROC} curve objects (if computed).

 A nested \code{tibble} with the \strong{confusion matrix}.
 The \code{Pos_} columns tells you whether a row is a
 True Positive (\code{TP}), True Negative (\code{TN}), False Positive (\code{FP}),
 or False Negative (\code{FN}), depending on which level is the "positive" class.
 I.e. the level you wish to predict.

 A nested \strong{Process} information object with information
 about the evaluation.

 Name of \strong{dependent} variable.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

 Create a baseline evaluation of a test set.

 In modelling, a \emph{baseline} is a result that
 is meaningful to compare the results from our models to. For instance, in
 classification, we usually want our results to be better than \emph{random guessing}.
 E.g. if we have three classes, we can expect an accuracy of \code{33.33\%}, as for every
 observation we have \code{1/3} chance of guessing the correct class. So our model should achieve
 a higher accuracy than \code{33.33\%} before it is more useful to us than guessing.

 While this expected value is often fairly straightforward to find analytically, it
 only represents what we can expect on average. In reality, it's possible to get far better
 results than that by guessing.
 \strong{\code{baseline_binomial()}}
 finds the range of likely values by evaluating multiple sets
 of random predictions and summarizing them with a set of useful descriptors. Additionally,
 it evaluates a set of all \code{0} predictions and
 a set of all \code{1} predictions.
}
\details{
Packages used:

 \code{ROC} and \code{AUC}: \code{\link[pROC:roc]{pROC::roc}}
}
\examples{
\donttest{
# Attach packages
library(cvms)
library(groupdata2) # partition()
library(dplyr) # \%>\% arrange()

# Data is part of cvms
data <- participant.scores

# Set seed for reproducibility
set.seed(1)

# Partition data
partitions <- partition(data, p = 0.7, list_out = TRUE)
train_set <- partitions[[1]]
test_set <- partitions[[2]]

# Create baseline evaluations
# Note: usually n=100 is a good setting

baseline_binomial(
  test_data = test_set,
  dependent_col = "diagnosis",
  n = 2
)

# Parallelize evaluations

# Attach doParallel and register four cores
# Uncomment:
# library(doParallel)
# registerDoParallel(4)

# Make sure to uncomment the parallel argument
baseline_binomial(
  test_data = test_set,
  dependent_col = "diagnosis",
  n = 4
  #, parallel = TRUE  # Uncomment
)
}
}
\seealso{
Other baseline functions: 
\code{\link{baseline}()},
\code{\link{baseline_gaussian}()},
\code{\link{baseline_multinomial}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{baseline functions}
