% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_predictors.R
\name{combine_predictors}
\alias{combine_predictors}
\alias{generate_formulas}
\title{Generate model formulas by combining predictors}
\usage{
combine_predictors(
  dependent,
  fixed_effects,
  random_effects = NULL,
  max_fixed_effects = 5,
  max_interaction_size = 3,
  max_effect_frequency = NULL
)
}
\arguments{
\item{dependent}{Name of dependent variable. (Character)}

\item{fixed_effects}{List of fixed effects. (Character)

 Max. limit of \code{8} effects \strong{when interactions are included}!

 A fixed effect name cannot contain: white spaces, \code{"*"} or \code{"+"}.

 Effects in sublists will be interchanged. This can be useful, when
 we have multiple versions of a predictor (e.g. \code{x1} and \code{log(x1)}) that we
 do not wish to have in the same formula.

 Example of interchangeable effects:

 \code{list( list( "x1", "log_x1" ), "x2", "x3" )}}

\item{random_effects}{The random effects structure. (Character)

 Is appended to the model formulas.}

\item{max_fixed_effects}{Maximum number of fixed effects in a model formula. (Integer)

 Max. limit of \code{5} \strong{when interactions are included}!}

\item{max_interaction_size}{Maximum number of effects in an interaction. (Integer)

 Max. limit of \code{3}.

 Use this to limit the \code{n}-way interactions allowed.
 \code{0} or \code{1} excludes interactions all together.

 A model formula can contain multiple interactions.}

\item{max_effect_frequency}{Maximum number of times an effect is included in a formula string.}
}
\value{
List of model formulas.

 E.g.:

 \code{c("y ~ x1 + (1|z)", "y ~ x2 + (1|z)",
 "y ~ x1 + x2 + (1|z)", "y ~ x1 * x2 + (1|z)")}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("maturing")}

 Create model formulas with every combination
 of your fixed effects, along with the dependent variable and random effects.
 \code{259,358} formulas have been precomputed with two- and three-way interactions
 for up to \code{8} fixed effects, with up to \code{5} included effects per formula.
 Uses the \code{+} and \code{*} operators, so lower order interactions are
 automatically included.
}
\examples{
# Attach packages
library(cvms)

# Create effect names
dependent <- "y"
fixed_effects <- c("a","b","c")
random_effects <- "(1|e)"

\donttest{
# Create model formulas
combine_predictors(dependent, fixed_effects,
                   random_effects)

}
# Create effect names with interchangeable effects in sublists
fixed_effects <- list("a",list("b","log_b"),"c")

\donttest{
# Create model formulas
combine_predictors(dependent, fixed_effects,
                   random_effects)
}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
