% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_data_availability}
\alias{cvd_data_availability}
\title{Data availability}
\usage{
cvd_data_availability(
  time_period_id = 1,
  system_level_id = 1,
  indicator_id,
  metric_category_type_id
)
}
\arguments{
\item{time_period_id}{integer - the time period to return data for (compulsory)}

\item{system_level_id}{integer - the system level to return data for (compulsory)}

\item{indicator_id}{integer - the indicator to return data for (optional)}

\item{metric_category_type_id}{integer - the metric category to return data for (optional)}
}
\value{
Tibble of data availability
}
\description{
Returns the data availability.
Response:
\code{DataAvailabilityID} - ID of the resource as found in the database
\code{DataAvailabilityName} - explanation for the data availability
\code{IsAvailable} - \code{Y} for data is available, \code{N} for data is unavailable, and NULL for unknown data
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2FdataAvailability}{Data availability}
}
\examples{
cvd_data_availability(time_period_id = 3, system_level_id = 5)
}
\seealso{
\code{\link[=cvd_external_resource]{cvd_external_resource()}}
}
