% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{linearShrinkLWEst}
\alias{linearShrinkLWEst}
\title{Ledoit-Wolf Linear Shrinkage Estimator}
\usage{
linearShrinkLWEst(dat)
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}
}
\value{
A \code{matrix} corresponding to the Ledoit-Wolf linear shrinkage
estimate of the covariance matrix.
}
\description{
\code{linearShrinkLWEst()} computes an asymptotically optimal
convex combination of the sample covariance matrix and the identity matrix.
This convex combination effectively shrinks the eigenvalues of the sample
covariance matrix towards the identity. This estimator is more accurate
than the sample covariance matrix in high-dimensional settings under fairly
loose assumptions. For more information, consider reviewing the manuscript
by \insertCite{Ledoit2004;textual}{cvCovEst}.
}
\examples{
linearShrinkLWEst(dat = mtcars)
}
\references{
\insertAllCited{}
}
