% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{adaptiveLassoEst}
\alias{adaptiveLassoEst}
\title{Adaptive LASSO Estimator}
\usage{
adaptiveLassoEst(dat, lambda, n)
}
\arguments{
\item{dat}{A numeric \code{data.frame}, \code{matrix}, or similar object.}

\item{lambda}{A non-negative \code{numeric} defining the amount of
thresholding applied to each element of \code{dat}'s sample covariance
matrix.}

\item{n}{A non-negative \code{numeric} defining the exponent of the adaptive
weight applied to each element of \code{dat}'s sample covariance matrix.}
}
\value{
A \code{matrix} corresponding to the estimate of the covariance
matrix.
}
\description{
\code{adaptiveLassoEst()} applied the adaptive LASSO to the
entries of the sample covariance matrix. The thresholding function is
inspired by the penalized regression introduced by
\insertCite{zou2006;textual}{cvCovEst}. The thresholding function assigns
a weight to each entry of the sample covariance matrix based on its
initial value. This weight then determines the relative size of the penalty
resulting in larger values being penalized less and reducing bias
\insertCite{rothman2009}{cvCovEst}.
}
\examples{
adaptiveLassoEst(dat = mtcars, lambda = 0.9, n = 0.9)
}
\references{
\insertAllCited{}
}
