% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{cv}
\alias{cv}
\alias{cv.default}
\alias{print.cv}
\alias{print.cvList}
\alias{cv.lm}
\alias{cv.glm}
\alias{cv.rlm}
\title{Cross-Validate Regression Models}
\usage{
cv(model, data, criterion, k, reps = 1, seed, ...)

\method{cv}{default}(
  model,
  data = insight::get_data(model),
  criterion = mse,
  k = 10,
  reps = 1,
  seed,
  confint = n >= 400,
  level = 0.95,
  ncores = 1,
  type = "response",
  ...
)

\method{print}{cv}(x, digits = getOption("digits"), ...)

\method{print}{cvList}(x, ...)

\method{cv}{lm}(
  model,
  data = insight::get_data(model),
  criterion = mse,
  k = 10,
  reps = 1,
  seed,
  confint = n >= 400,
  level = 0.95,
  method = c("auto", "hatvalues", "Woodbury", "naive"),
  ncores = 1,
  ...
)

\method{cv}{glm}(
  model,
  data = insight::get_data(model),
  criterion = mse,
  k = 10,
  reps = 1,
  seed,
  confint = n >= 400,
  level = 0.95,
  method = c("exact", "hatvalues", "Woodbury"),
  ncores = 1,
  ...
)

\method{cv}{rlm}(model, data, criterion, k, reps = 1, seed, ...)
}
\arguments{
\item{model}{a regression model object (see Details).}

\item{data}{data frame to which the model was fit (not usually necessary).}

\item{criterion}{cross-validation criterion ("cost" or lack-of-fit) function of form \code{f(y, yhat)}
where \code{y} is the observed values of the response and
\code{yhat} the predicted values; the default is \code{\link{mse}}
(the mean-squared error).}

\item{k}{perform k-fold cross-validation (default is \code{10}); \code{k}
may be a number or \code{"loo"} or \code{"n"} for n-fold (leave-one-out)
cross-validation.}

\item{reps}{number of times to replicate k-fold CV (default is \code{1})}

\item{seed}{for R's random number generator; optional, if not
supplied a random seed will be selected and saved; not needed
for n-fold cross-validation}

\item{...}{to match generic; passed to \code{predict()} for the default method.}

\item{confint}{if \code{TRUE} (the default if the number of cases is 400
or greater), compute a confidence interval for the bias-corrected CV
criterion, if the criterion is the average of casewise components.}

\item{level}{confidence level (default \code{0.95}).}

\item{ncores}{number of cores to use for parallel computations
(default is \code{1}, i.e., computations aren't done in parallel)}

\item{type}{for the default method, value to be passed to the
\code{type} argument of \code{predict()};
the default is \code{type="response"}, which is appropriate, e.g., for a \code{"glm"} model
and may be recognized or ignored by \code{predict()} methods for other model classes.}

\item{x}{a \code{"cv"} or \code{"cvList"} object to be printed}

\item{digits}{significant digits for printing,
default taken from the \code{"digits"} option}

\item{method}{computational method to apply to a linear (i.e. \code{"lm"}) model
or to a generalized linear (i.e., \code{"glm"}) model. See Details for an explanation
of the available options.}
}
\value{
The \code{cv()} methods return an object of class \code{"cv"}, with the CV criterion
(\code{"CV crit"}), the bias-adjusted CV criterion (\code{"adj CV crit"}),
the criterion for the model applied to the full data (\code{"full crit"}),
the confidence interval and level for the bias-adjusted CV criterion (\code{"confint"}),
the number of folds (\code{"k"}), and the seed for R's random-number
generator (\code{"seed"}). Some methods may return a
subset of these components and may add additional information.
If \code{reps} > \code{1}, then an object of class \code{"cvList"} is returned,
which is literally a list of \code{"cv"} objects.
}
\description{
A parallelized generic k-fold (including n-fold, i.e., leave-one-out)
cross-validation function, with a default method, and
specific methods for linear and generalized-linear models that can be much
more computationally efficient.
}
\details{
The default \code{cv()} method uses \code{\link{update}()} to refit the model
to each fold, and should work if there are appropriate \code{update()}
and \code{\link{predict}()} methods, and if the default method for \code{\link{GetResponse}()}
works or if a \code{GetResponse()} method is supplied.

The \code{"lm"} and \code{"glm"} methods can use much faster computational
algorithms, as selected by the \code{method} argument. The linear-model
method accommodates weighted linear models.

For both classes of models, for the leave-one-out (n-fold) case, fitted values
for the folds can be computed from the hat-values via
\code{method="hatvalues"} without refitting the model;
for GLMs, this method is approximate, for LMs it is exact.

Again for both classes of models, when more than one case is omitted
in each fold, fitted values may be obtained without refitting the
model by exploiting the Woodbury matrix identity via \code{method="Woodbury"}.
As for hatvalues, this method is exact for LMs and approximate for
GLMs.

The default for linear models is \code{method="auto"},
which is equivalent to \code{method="hatvalues"} for n-fold cross-validation
and \code{method="Woodbury"} otherwise; \code{method="naive"} refits
the model via \code{update()} and is generally much slower. The
default for generalized linear models is \code{method="exact"},
which employs \code{update()}.

There is also a method for robust linear models fit by
\code{\link[MASS]{rlm}()} in the \pkg{MASS} package (to avoid
inheriting the \code{"lm"} method for which the default \code{"auto"}
computational method would be inappropriate).

For additional details, see the "Cross-validation of regression models"
vignette (\code{vignette("cv", package="cv")}).

\code{cv()} is designed to be extensible to other classes of regression
models; see the "Extending the cv package" vignette
(\code{vignette("cv-extend", package="cv")}).
}
\section{Methods (by class)}{
\itemize{
\item \code{cv(default)}: \code{default} method

\item \code{cv(lm)}: \code{"lm"} method

\item \code{cv(glm)}: \code{"glm"} method

\item \code{cv(rlm)}: \code{"rlm"} method (to avoid inheriting the \code{"lm"} method)

}}
\section{Methods (by generic)}{
\itemize{
\item \code{print(cv)}: \code{print()} method

}}
\section{Functions}{
\itemize{
\item \code{print(cvList)}: \code{print()} method

}}
\examples{
data("Auto", package="ISLR2")
m.auto <- lm(mpg ~ horsepower, data=Auto)
cv(m.auto,  k="loo")
cv(m.auto, seed=1234)
cv(m.auto, seed=1234, reps=3)

data("Mroz", package="carData")
m.mroz <- glm(lfp ~ ., data=Mroz, family=binomial)
cv(m.mroz, criterion=BayesRule, seed=123)

data("Duncan", package="carData")
m.lm <- lm(prestige ~ income + education, data=Duncan)
m.rlm <- MASS::rlm(prestige ~ income + education,
                   data=Duncan)
cv(m.lm, k="loo", method="Woodbury")
cv(m.rlm, k="loo")
}
\seealso{
\code{\link{cvMixed}}, \code{\link{cvSelect}}.
}
