% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutpointr.R
\name{cutpointr_}
\alias{cutpointr_}
\title{The standard evaluation version of cutpointr}
\usage{
cutpointr_(data, x, class, subgroup = NULL, method = maximize_metric,
  metric = sum_sens_spec, pos_class = NULL, neg_class = NULL,
  direction = NULL, boot_runs = 0, use_midpoints = FALSE,
  break_ties = median, na.rm = FALSE, allowParallel = FALSE,
  silent = FALSE, tol_metric = 1e-06, ...)
}
\arguments{
\item{data}{A data.frame with the data needed for x, class and subgroup.}

\item{x}{(character) The variable name to be used for
classification, e.g. predictions or test values.}

\item{class}{(character) The variable name indicating class membership.}

\item{subgroup}{(character) The variable name
of an additional covariate that identifies subgroups. Separate
optimal cutpoints will be determined per group.}

\item{method}{(function) A function for determining cutpoints. Can
be user supplied or use some of the built in methods. See details.}

\item{metric}{(function) The function for computing a metric when using
maximize_metric or minimize_metric as method and and for the
out-of-bag values during bootstrapping. A way of internally validating the performance.
User defined functions can be supplied, see details.}

\item{pos_class}{(optional) The value of class that indicates the positive class.}

\item{neg_class}{(optional) The value of class that indicates the negative class.}

\item{direction}{(character, optional) Use ">=" or "<=" to indicate whether x
is supposed to be larger or smaller for the positive class.}

\item{boot_runs}{(numerical) If positive, this number of bootstrap samples
will be used to assess the variability and the out-of-sample performance.}

\item{use_midpoints}{(logical) If TRUE (default FALSE) the returned optimal
cutpoint will be the mean of the optimal cutpoint and the next highest
observation (for direction = ">=") or the next lowest observation
(for direction = "<=") which avoids biasing the optimal cutpoint.}

\item{break_ties}{If multiple cutpoints are found, they can be summarized using
this function, e.g. mean or median. To return all cutpoints use c as the function.}

\item{na.rm}{(logical) Set to TRUE (default FALSE) to keep only complete
cases of x, class and subgroup (if specified). Missing values with
na.rm = FALSE will raise an error.}

\item{allowParallel}{(logical) If TRUE, the bootstrapping will be parallelized
using foreach. A local cluster, for example, should be started manually
beforehand.}

\item{silent}{(logical) If TRUE suppresses all messages.}

\item{tol_metric}{All cutpoints will be returned that lead to a metric
value in the interval [m_max - tol_metric, m_max + tol_metric] where
m_max is the maximum achievable metric value. This can be used to return
multiple decent cutpoints and to avoid floating-point problems. Not supported
by all \code{method} functions, see details.}

\item{...}{Further optional arguments that will be passed to method.
minimize_metric and maximize_metric pass ... to metric.}
}
\description{
This function is equivalent to \code{cutpointr} but takes only quoted arguments
for \code{x}, \code{class} and \code{subgroup}. This function is suitable for
programming with. For details on \code{cutpointr} see help("cutpointr").
}
\examples{
library(cutpointr)

## Optimal cutpoint for dsi
data(suicide)
opt_cut <- cutpointr_(suicide, "dsi", "suicide")
opt_cut
summary(opt_cut)
plot(opt_cut)
predict(opt_cut, newdata = data.frame(dsi = 0:5))
}
\seealso{
Other main cutpointr functions: \code{\link{add_metric}},
  \code{\link{cutpointr}}, \code{\link{multi_cutpointr}},
  \code{\link{predict.cutpointr}}, \code{\link{roc}}
}
\concept{main cutpointr functions}
