\name{read.fmrislice}
\alias{read.fmrislice}
\concept{read fmri data}
\title{ Read fMRI data}
\description{
  \code{read.fmrislice} 
	reads pre-filtered fMRI data, mask data, and the design matrix to be used
	in fMRI data processing.}
		
\usage{read.fmrislice(fbase=NULL, slice=NULL, swap=FALSE)} 

\arguments{
\item{fbase}{If \code{fbase} is left unspecified (default \code{NULL}),
  then user datasets need to be provided as input. Otherwise, \code{fbase}
  indicates the dataset prefix of one of the two demo fMRI datasets to use.
  Three data files are required as input.
  User specified data files must have the names generated by the FSL/FEAT
  pre-processing tool, namely \cr
  \file{filtered_func_data.nii.gz}, \file{mask.nii.gz}, and \file{design.mat}.\cr
  \file{filtered_func_data.nii.gz} specifies the dataset to be analyzed,\cr
  \file{mask.nii.gz} specifies the dataset to be used as mask. \cr
  \file{design.mat} specifies the dataset to be used as design matrix.\cr
  Typically, these datasets are obtained using the FSL/FEAT pre-processing tool,
  or other similar tool.\cr
	In \pkg{cudaBayesreg}, versions 10+, \code{read.fmrislice}
	uses the \file{design.mat} format from FSL/FEAT.\cr
	The prefix \code{fbase} applies to the demo data files provided in the
	 complementary package \pkg{cudaBayesregData}:\cr
	\file{\{fbase\}_filtered_func.nii.gz}, \cr
	\file{\{fbase\}_mask.nii.gz},	and \cr
	\file{\{fbase\}_design.mat}.\cr
	Two test datasets are included in the package: one with prefix \samp{fmri},
		the other with prefix \samp{swrfM}.
	The prefix \samp{swrfM} is used in the random effects example.
	See also \code{read.Zsegslice} for user-defined segmented masks. }
\item{slice}{the number of the slice to use. If a slice number is not specified
  a central slice  from the provided dataset (mid-brain, in general) is assumed 
  (default \code{NULL}).}
\item{swap}{logical variable (default = \code{FALSE}) for choosing the
  right/left data display convention consistent with FSLVIEW.}  
}

\details{The FSL/FEAT Analysis tool may be used to generate the prefiltered fMRI data
  (niislicets), the mask (mask), and the design matrix (dsgn) required as data input.
  The FSL-design file \emph{design.mat} is simply a ASCII textfile with the fields
  \emph{/NumWaves}, \emph{/NumPoints}, \emph{/PPheights}, and \emph{/Matrix}.
  Therefore, it may easily edited, if required, to prepare user specific design matrices
  without the FSL/FEAT tool.
  The package \pkg{oro.nifti} is required for reading gzipped NIFTI files.
}

\value{a list containing
	\item{fbase}{dataset prefix of the dataset used in the analysis}
	\item{slice}{slice number}
	\item{niislicets}{slice data at all timepoints}
	\item{mask}{slice mask}
	\item{X}{full design matrix}
	\item{nvar}{number of regression variables}
	\item{nobs}{number of observations}
	\item{swap}{relative orientation used in the data setup}
}

\references{
FSL/FEAT Analysis tool, FMRIB Software Library (FSL) (\url{www.fmrib.ox.ac.uk/fsl})

Brandon Whitcher, Volker Schmid and Andrew Thornton (2011), R package \pkg{oro.nifti}: Rigorous - NIfTI Input / Output, R package version 0.2.5,\cr
\url{http://CRAN.R-project.org/package=oro.nifti}.
}

\author{A. Ferreira da Silva, Universidade Nova de Lisboa,
Faculdade de Ciencias e Tecnologia,\cr \email{afs@fct.unl.pt}.
}
\seealso{
  \code{\link{cudaMultireg.slice}}
  \code{\link{read.Zsegslice}}
  \code{\link{premask}}}
\examples{
\dontrun{
slicedata <- read.fmrislice(fbase="fmri", slice=3)
print(str(slicedata))
}}

\keyword{IO}
