% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCheckFit.R
\name{plot.ctsemFitMeasure}
\alias{plot.ctsemFitMeasure}
\title{Misspecification plot using ctCheckFit output}
\usage{
\method{plot}{ctsemFitMeasure}(
  x,
  indices = "all",
  means = TRUE,
  separatemeans = TRUE,
  cov = TRUE,
  covtype = "MisspecRatio",
  cov2cor = FALSE,
  wait = TRUE,
  ggcorrArgs = list(data = NULL, cor_matrix = get(covtype), limits = limits, geom =
    "circle", max_size = 10, name = covtype),
  ...
)
}
\arguments{
\item{x}{Object output from ctCheckFit function.}

\item{indices}{Either 'all' or a vector of integers denoting which observations to 
include (from 1 to n.manifest * maximum number of obs for a subject, blocked by manifest).}

\item{means}{Logical -- plot simulated means vs observed?}

\item{separatemeans}{Logical -- means from different variables on same or different plots?}

\item{cov}{Logical -- plot simulated cov vs observed?}

\item{covtype}{Column name of \code{$cov} sub object}

\item{cov2cor}{Logical -- convert covariances to correlations?}

\item{wait}{Logical -- wait for input before new plot?}

\item{ggcorrArgs}{List of arguments to GGally::ggcorr .}

\item{...}{not used.}
}
\value{
Nothing, just plots.
}
\description{
Misspecification plot using ctCheckFit output
}
\examples{
if(w32chk()){


scheck <- ctCheckFit(ctstantestfit,niter=50)
plot(scheck,wait=FALSE)

}
}
