% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanoptimis.R
\name{stanoptimis}
\alias{stanoptimis}
\title{Optimize / importance sample a stan or ctStan model.}
\usage{
stanoptimis(
  standata,
  sm,
  init = "random",
  initsd = 0.01,
  sampleinit = NA,
  deoptim = FALSE,
  estonly = FALSE,
  tol = 1e-14,
  decontrol = list(),
  stochastic = FALSE,
  nopriors = FALSE,
  carefulfit = TRUE,
  plot = FALSE,
  is = FALSE,
  isloopsize = 1000,
  finishsamples = 500,
  tdf = 10,
  chancethreshold = 100,
  finishmultiply = 5,
  verbose = 0,
  cores = 2
)
}
\arguments{
\item{standata}{list object conforming to rstan data standards.}

\item{sm}{compiled stan model object.}

\item{init}{vector of unconstrained parameter values, or character string 'random' to initialise with
random values very close to zero.}

\item{initsd}{positive numeric specifying sd of normal distribution governing random sample of init parameters,
if init='random' .}

\item{sampleinit}{either NA, or an niterations * nparams matrix of samples to initialise importance sampling.}

\item{deoptim}{Do first pass optimization using differential evolution? Slower, but better for cases with multiple
minima / difficult optimization.}

\item{estonly}{if TRUE,just return point estimates under $rawest subobject.}

\item{tol}{objective tolerance.}

\item{decontrol}{List of control parameters for differential evolution step, to pass to \code{DEoptim.control}.}

\item{stochastic}{Logical. Use stochastic gradient descent instead of mize (bfgs) optimizer.
Still experimental, worth trying for either robustness checks or problematic, high dimensional, nonlinear, problems.}

\item{nopriors}{logical. If TRUE, a nopriors integer is set to 1 (TRUE) in the standata object -- only has an effect if 
the stan model uses this value.}

\item{carefulfit}{Logical. If TRUE, priors are always used for a rough first pass to obtain starting values when nopriors=TRUE.}

\item{plot}{Logical. If TRUE, plot iteration details. Probably slower.}

\item{is}{Logical. Use importance sampling, or just return map estimates?}

\item{isloopsize}{Number of samples of approximating distribution per iteration of importance sampling.}

\item{finishsamples}{Number of samples to draw for final results of importance sampling.}

\item{tdf}{degrees of freedom of multivariate t distribution. Higher (more normal) generally gives more efficent
importance sampling, at risk of truncating tails.}

\item{chancethreshold}{drop iterations of importance sampling where any samples are chancethreshold times more likely to be drawn than expected.}

\item{finishmultiply}{Importance sampling stops once available samples reach \code{finishsamples * finishmultiply} , then the final samples are drawn
without replacement from this set.}

\item{verbose}{Integer from 0 to 2. Higher values print more information during model fit -- for debugging.}

\item{cores}{Number of cpu cores to use, should be at least 2.}
}
\value{
list containing fit elements
}
\description{
Optimize / importance sample a stan or ctStan model.
}
\examples{
\donttest{

library(rstan)
scode <- "
parameters {
  real y[2];
}
model {
  y[1] ~ normal(0, 1);
  y[2] ~ double_exponential(0, 2);
}
"

sm <- stan_model(model_code=scode)
fit <- sampling(sm, iter = 10000)
summary(fit)$summary

## extract samples as a list of arrays
e <- ctExtract(fit, permuted = TRUE)

#for ml or map estimates
optimis <- stanoptimis(standata = list(),sm = sm,finishsamples = 3000,cores=2)
optimis$optimfit

#for posterior distributions
optimis <- stanoptimis(standata = list(),sm = sm,finishsamples = 3000,cores=2,tdf=5)

apply(optimis$rawposterior,2,mean)
apply(optimis$rawposterior,2,sd)
isdiag(optimis)

plot(density(optimis$rawposterior[,2],bw=.05))
points(density(e$y[,2],bw=.05),type='l',col=2)
}
}
