% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_sampleSize.R
\name{f.sampleSize}
\alias{f.sampleSize}
\title{Calculate sample size of a study}
\usage{
f.sampleSize(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.sampleSize`, an integer.
}
\description{
Trial concept calculated: sample size of the trial, preferring
results-related over protocol-related information.
}
\examples{
# fields needed
f.sampleSize()

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.sampleSize",
  con = dbc)
trialsDf

}
