% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_trialObjectives.R
\name{f.trialObjectives}
\alias{f.trialObjectives}
\title{Calculate objectives of a study}
\usage{
f.trialObjectives(df = NULL)
}
\arguments{
\item{df}{data frame such as from \link{dbGetFieldsIntoDf}. If `NULL`,
prints fields needed in `df` for calculating this trial concept, which can
be used with \link{dbGetFieldsIntoDf}.}
}
\value{
data frame with columns `_id` and `.trialObjectives`, which is
a string with letters separated by a space, such as
E (efficacy, including cure, survival, effectiveness);
A (activity, including reponse, remission, seroconversion);
S (safety); PK; PD (including biomarker);
D (dose-finding, determining recommended dose);
LT (long-term); and FU (follow-up).
}
\description{
Trial concept calculated: objectives of the trial, by searching for text
fragments found in fields describing its purpose, objective, background
or hypothesis, after applying .isMedIntervTrial, because the text
fragments are tailored to medicinal product interventional trials.
This is a simplification, and it is expected that the criteria will be
further refined. The text fragments only apply to English.
}
\examples{
# fields needed
f.trialObjectives()

\dontrun{

# apply trial concept when creating data frame
dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials", flags = RSQLite::SQLITE_RO)
trialsDf <- dbGetFieldsIntoDf(
  calculate = "f.trialObjectives",
  con = dbc)
}

}
