% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_mutations_in_phase.R
\name{merge_mutations_in_phase}
\alias{merge_mutations_in_phase}
\title{Collapses mutations in phase into one event}
\usage{
merge_mutations_in_phase(mutations, bam, tag = "",
  ID_column = "phasingID", min_base_quality = 20, min_mapq = 30)
}
\arguments{
\item{mutations}{A data frame with the reporter mutations. Should have the columns CHROM, POS, REF, ALT.}

\item{bam}{path to bam file}

\item{tag}{the RG tag if the bam has more than one sample}

\item{ID_column}{The name of the column in mutations data.frame that has the IDs for mutations in phase.
NA values will be filled automatically by unique mutation identifiers.}

\item{min_base_quality}{minimum base quality for a read to be counted}

\item{min_mapq}{integer specifying the minimum mapping quality for reads to be included.}
}
\value{
A list with the following slots:
\describe{
 \item{out:}{ A data frame that has the columns:
      \itemize{
        \item Phasing_id: the ID of the mutations/event.
        \item ref: number of reference reads.
        \item alt: number of alternative reads.
        \item n_reads_multi_mutation: Number of reads that span more than one mutation in phase.
        \item all_reads: total number of reads.
        \item multi_support: number of reads that support the alt allele of multiple mutations in phase.
      }}
 \item{purification_prob:}{Probability of purification: sum(n_reads_multi_mutation)/sum(all_reads)}
 \item{multi_support:}{Number of multi-support reads in all mutations/events}
 \item{informative_reads:}{Number of unique reads covering the mutations/events}
}
}
\description{
Given a mutations data frame and a bam file, this function collapses mutations in phase identified by the ID_column into one event.
While doing that, it ignores the reads that support both the reference and alternative alleles for different mutations in phase.
}
\details{
Mutations in phase are those that are supported by the same reads (same allele). The function doesn't identify mutations in phase, but rather use
an ID column in the input whose name is specified by ID_column to tell which mutations are in phase.

Since two or more mutations can be supported by the same evidence,
this function merges these mutations into one event. The function will also remove the mismatches that are not exhibited in all the covered phased mutations (since
this function is developed for the intent of minimal residual disease testing).

The output will include the merged mutations, the probability of purification, which is defined as the number of
reads covering at least two mutations in phase divided by the number of informative reads.
Informative reads count is the total number of unique reads mapping to the mutations input
(including both mutations in phase and other mutations).
}
\examples{
data("mutations", package = "ctDNAtools")
bamT1 <- system.file("extdata", "T1.bam", package = "ctDNAtools")
merge_mutations_in_phase(mutations = mutations[5:10, ], bam = bamT1, ID_column = "PHASING")
}
\seealso{
\code{\link{test_ctDNA}} \code{\link{get_mutations_read_names}}
}
