% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_cspp_data.R
\name{get_cspp_data}
\alias{get_cspp_data}
\title{Load CSPP data into the R environment}
\usage{
get_cspp_data(
  vars = NULL,
  var_category = NULL,
  states = NULL,
  years = NULL,
  output = NULL,
  path = ""
)
}
\arguments{
\item{vars}{Default is NULL. If left blank, returns all variables within the
dataset. Takes a string or vector of strings. See
\code{\link{get_var_info}} for pulling variable names and
\code{\link{get_cites}} for citations of specific variables and datasets.
Names of variables must be exact matches to variables in the dataset.}

\item{var_category}{Default is NA. If left blank, returns all datasets. Takes
  a string or vector of strings.

  Options are one of, or a combination of: "demographics", "economic-fiscal",
  "government", "elections", "policy_ideology", "criminal justice",
  "education", "healthcare", "welfare", "rights", "environment",
  "drug-alcohol", "gun control", "labor", "transportation", "misc.
  regulation"}

\item{states}{Default is NULL. If left blank, returns all states. Takes a
string or vector of strings of state abbreviations. Use \code{state.abb} to
load state abbreviations into the R environment.}

\item{years}{Default is NULL. If left blank, returns all years. Coverage
  begins at 1900 and runs to 2019. However, coverage depends on the specific
  variable -- see \code{get_var_info}.

  Input can be a vector of years (or a singular year), such as c(2000, 2001,
  2002, 2012) or seq(2000, 2012).}

\item{output}{Default is NULL. One of "csv", "dta", "rdata". Optional
parameter for writing the resulting dataframe to a file.}

\item{path}{The directory to write the file to. Default is blank, so writes to
working directory. Exclude final slash: e.g., \code{path = "dir1/dir2"}}
}
\description{
\code{get_cspp_data} loads either a full or subsetted version of the full
CSPP dataset into the R environment as a dataframe.
}
\examples{

## returns full dataset
data <- get_cspp_data()

## use variable names from get_var_info
data <- get_cspp_data(vars = get_var_info(var_names="pctpop")$variable)

## return subsets
# note: this returns the specific variables listed as well as those in the
# var_category argument
data <- get_cspp_data(vars = c("sess_length", "hou_majority", "term_length"),
                      var_category = "demographics",
                      states = c("NC", "VA", "GA"),
                      years = seq(1995, 2004))


}
\seealso{
\code{\link{get_var_info}}, \code{\link{get_cites}}, \code{\link{generate_map}}
}
