% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_bollingerbands.R
\name{bollinger_bands}
\alias{bollinger_bands}
\title{Add Bollinger Bands
to the chart}
\usage{
bollinger_bands(
   n = 20,
   sd = 2,
   maType = "SMA",
   color  = '#4682b4',
   ...
)
}
\arguments{
\item{n}{Number of periods for moving average.}

\item{sd}{The number of standard deviations to use.}

\item{maType}{A function or a string naming the function to be called.}

\item{color}{A \link{character}-vector of \link{length} 1. "#4682b4" by default.}

\item{...}{Other arguments to be passed to the \code{maType} function.}
}
\value{
An \link{invisible} \code{\link[plotly:plot_ly]{plotly::plot_ly()}}-object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

A high-level \code{\link[plotly:add_trace]{plotly::add_lines()}}-wrapper function that interacts
with the \code{\link[TTR:bollingerBands]{TTR::BBands()}}-function. The function adds bollinger bands
to the main \code{\link[=chart]{chart()}}.
}
\examples{
# script start;

# Charting BTC using
# candlesticks as main
# chart
cryptoQuotes::chart(
  ticker = BTC,
  main   = cryptoQuotes::kline(),
  sub    = list(
    cryptoQuotes::volume()
  )
)

# script end;
}
\seealso{
Other chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{chart}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{fgi}()},
\code{\link{hma}()},
\code{\link{lsr}()},
\code{\link{macd}()},
\code{\link{rsi}()},
\code{\link{sma}()},
\code{\link{smi}()},
\code{\link{volume}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}

Other main chart indicators: 
\code{\link{add_event}()},
\code{\link{alma}()},
\code{\link{dema}()},
\code{\link{donchian_channel}()},
\code{\link{ema}()},
\code{\link{evwma}()},
\code{\link{hma}()},
\code{\link{sma}()},
\code{\link{vwap}()},
\code{\link{wma}()},
\code{\link{zlema}()}
}
\author{
Serkan Korkmaz
}
\concept{chart indicators}
\concept{main chart indicators}
