% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_markets.R
\name{global_market}
\alias{global_market}
\title{Global cryptocurrency market data}
\usage{
global_market(market = NULL)
}
\arguments{
\item{market}{Either 'total' or 'altcoin'}
}
\value{
Daily timeseries of token data in a dataframe:
  \item{timestamp}{Timestamp (POSIXct)}
  \item{market_cap}{Market Cap in USD}
  \item{volume}{Volume traded in USD}
}
\description{
Retrieve daily snapshot of market_cap and the volume traded
for either total cryptocurrency market or the altcoin market
only. Selecting 'total' will include bitcoin and all altcoins.
}
\examples{
market         <- "total"
global_markets <- global_market(market)
}
