% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clattice.R
\name{frac_to_orth}
\alias{frac_to_orth}
\title{From fractional to orthogonal coordinates}
\usage{
frac_to_orth(xyzf, a, b, c, aa, bb, cc, ochoice = 1)
}
\arguments{
\item{xyzf}{A vector or \eqn{n\times 3} matrix or data frame of fractional crystal coordinates.}

\item{a}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{b}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{c}{A real number. One of the unit cell's side lengths, in angstroms.}

\item{aa}{A real number. One of the unit cell's angles, in degrees.}

\item{bb}{A real number. One of the unit cell's angles, in degrees.}

\item{cc}{A real number. One of the unit cell's angles, in degrees.}

\item{ochoice}{A natural integer indicating the choice of orthogonal transformation.
1 corresponds to the first choice and 2 to the second choice in
Giacovazzo's book (see \code{\link{xtal_mat01}} and \code{\link{xtal_mat02}}).}
}
\value{
A \eqn{n\times 3} matrix or data frame of orthogonal coordinates corresponding
        to the fractional coordinates provided in the input.
}
\description{
This function transforms any number of fractional coordinates \eqn{(x_f,y_f,z_f)},
arranged as a vector or in a matrix or data frame, into the corresponding number
of orthogonal coordinates \eqn{(x,y,z)}, arranged in the same format.
\enumerate{
\item ochoice = 1: X axis along a; Y axis normal to a, in the (a,b) plane;
             Z axis normal to X and Y (and therefore parallel to
             c*).
\item ochoice = 2: this is also called "Cambridge setting". The X axis is
             along a*; the Y axis lies in the (a*,b*) plane; the Z
             axis is, consequently, along c.
}
}
\examples{
# Matrix containing 3 fractional coordinates
xyzf <- matrix(c(0.1,0.2,0.3,0.2,0.6,0.7,0.15,0.28,0.55),ncol=3,byrow=TRUE)

# Cartesian coordinates
xyz <- frac_to_orth(xyzf,10,30,20,90,90,90,1)
}
