% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-export.R
\name{extractNetCDF}
\alias{extractNetCDF}
\title{extractNetCDF function}
\usage{
extractNetCDF(nc, start = NULL, count = NULL)
}
\arguments{
\item{nc}{an object inheriting class ncdf}

\item{start}{the start index. A vector of indices indicating where to start reading the passed values (beginning at 1).  The length of this vector must equal the number of dimensions the variable has.  If not specified, reading starts at the beginning of the file (1,1,1,...).}

\item{count}{A vector of integers indicating the count of values to read along each dimension.  The length of this vector must equal the number of dimensions the variable has. If not specified and the variable does NOT have an unlimited dimension, the entire variable is read.  As a special case, the value '-1' indicates that all entries along that dimension should be read. By default this extracts data for the  first time point.}
}
\value{
an array or matrix with the requested data
}
\description{
A function to extract data from CRU TS NetCDF files. A wrapper function for get.var.ncdf.
}
\examples{
\dontrun{extractNetCDF(dat=dat)}
\dontrun{extractNetCDF(dat=dat,start=c(1,1,1,1),count=c(1,2,3,1))}
\dontrun{extractNetCDF(dat=dat,start=c(1,1,1,1),count=c(-1,1,1,1))}
}

