% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/abstract-categories.R,
%   R/abstract-category.R, R/categories.R, R/crunch-data-frame.R,
%   R/cube-dims.R, R/cube-subset.R, R/cube-transforms.R, R/dataset-catalog.R,
%   R/dataset-extract.R, R/dataset-update.R, R/shoji-catalog.R,
%   R/decks.R, R/expressions.R, R/filters.R, R/members.R, R/multitables.R,
%   R/permission-catalog.R, R/project-folder.R, R/shoji-folder.R,
%   R/shoji-order.R, R/slides.R, R/subvariables.R, R/tab-book.R, R/teams.R,
%   R/user.R, R/variable-catalog.R, R/variable-order.R, R/variable-update.R,
%   R/variable.R
\docType{methods}
\name{crunch-extract}
\alias{crunch-extract}
\alias{[,AbstractCategories,ANY,ANY-method}
\alias{[,AbstractCategories,character,ANY-method}
\alias{[,AbstractCategories,numeric,ANY-method}
\alias{[<-,AbstractCategories,character,ANY,ANY-method}
\alias{[[,AbstractCategories,character-method}
\alias{[[<-,AbstractCategories,character,ANY,ANY-method}
\alias{$,AbstractCategory-method}
\alias{$<-,AbstractCategory-method}
\alias{[<-,Categories,ANY,ANY,ANY-method}
\alias{[.CrunchDataFrame}
\alias{[<-.CrunchDataFrame}
\alias{[[.CrunchDataFrame}
\alias{[[<-.CrunchDataFrame}
\alias{$.CrunchDataFrame}
\alias{$<-.CrunchDataFrame}
\alias{[,CubeDims,ANY,ANY-method}
\alias{[,CrunchCube,ANY,ANY-method}
\alias{[[<-,TransformsList,ANY,missing,NULL-method}
\alias{[[,DatasetCatalog,numeric-method}
\alias{[[<-,DatasetCatalog,character,missing,DatasetTuple-method}
\alias{[,CrunchDataset,ANY,ANY-method}
\alias{[,CrunchDataset,logical,missing-method}
\alias{[,CrunchDataset,character,ANY-method}
\alias{[,CrunchDataset,VariableGroup,ANY-method}
\alias{[,CrunchDataset,VariableOrder,ANY-method}
\alias{[,CrunchDataset,missing,ANY-method}
\alias{[,CrunchDataset,CrunchLogicalExpr,missing-method}
\alias{[,CrunchDataset,CrunchLogicalExpr,ANY-method}
\alias{subset,CrunchDataset-method}
\alias{[[,CrunchDataset,ANY-method}
\alias{[[,CrunchDataset,character-method}
\alias{$,CrunchDataset-method}
\alias{[[<-,CrunchDataset,character,missing,CrunchVariable-method}
\alias{[[<-,CrunchDataset,ANY,missing,CrunchVariable-method}
\alias{[[<-,CrunchDataset,character,missing,ANY-method}
\alias{[[<-,CrunchDataset,character,missing,CrunchLogicalExpr-method}
\alias{[[<-,CrunchDataset,ANY,ANY,ANY-method}
\alias{[[<-,CrunchDataset,character,missing,NULL-method}
\alias{[[<-,CrunchDataset,ANY,missing,NULL-method}
\alias{$<-,CrunchDataset-method}
\alias{[[<-,CrunchDataset,character,missing,CrunchGeography-method}
\alias{[[<-,CrunchDataset,ANY,missing,CrunchGeography-method}
\alias{[<-,CrunchDataset,ANY,missing,list-method}
\alias{[<-,CrunchDataset,ANY,missing,CrunchDataset-method}
\alias{[<-,CrunchDataset,CrunchExpr,ANY,ANY-method}
\alias{[,ShojiCatalog,character,ANY-method}
\alias{[,ShojiCatalog,numeric,ANY-method}
\alias{[,ShojiCatalog,logical,ANY-method}
\alias{[,ShojiCatalog,ANY,ANY-method}
\alias{[[,ShojiCatalog,ANY-method}
\alias{[[,ShojiCatalog,character-method}
\alias{$,ShojiCatalog-method}
\alias{$<-,ShojiCatalog-method}
\alias{[<-,ShojiCatalog,ANY,missing,ShojiCatalog-method}
\alias{[[,DeckCatalog,ANY-method}
\alias{[[,DeckCatalog,character-method}
\alias{[[<-,DeckCatalog,ANY,missing,CrunchDeck-method}
\alias{[[,CrunchDeck,ANY-method}
\alias{[[<-,CrunchDeck,ANY,ANY,ANY-method}
\alias{[,CrunchExpr,CrunchLogicalExpr,ANY-method}
\alias{[,CrunchExpr,logical,ANY-method}
\alias{[,CrunchExpr,numeric,ANY-method}
\alias{[[,FilterCatalog,numeric-method}
\alias{[[<-,FilterCatalog,character,missing,CrunchLogicalExpr-method}
\alias{[[<-,FilterCatalog,numeric,missing,CrunchLogicalExpr-method}
\alias{[[<-,FilterCatalog,character,missing,CrunchFilter-method}
\alias{[[<-,FilterCatalog,numeric,missing,CrunchFilter-method}
\alias{[[,MemberCatalog,character-method}
\alias{[[<-,MemberCatalog,ANY,missing,ANY-method}
\alias{[[<-,MemberCatalog,character,missing,NULL-method}
\alias{[[,MultitableCatalog,numeric-method}
\alias{[[<-,MultitableCatalog,character,missing,formula-method}
\alias{[[<-,MultitableCatalog,numeric,missing,formula-method}
\alias{[[<-,MultitableCatalog,ANY,missing,Multitable-method}
\alias{[[<-,MultitableCatalog,ANY,missing,NULL-method}
\alias{[[,PermissionCatalog,character-method}
\alias{[[<-,ProjectFolder,character,missing,list-method}
\alias{[[<-,ProjectFolder,character,missing,ProjectFolder-method}
\alias{[[,ShojiFolder,numeric-method}
\alias{[[,ShojiFolder,character-method}
\alias{[,ShojiOrder,ANY,ANY-method}
\alias{[,ShojiOrder,character,ANY-method}
\alias{[[,ShojiOrder,ANY-method}
\alias{[[,ShojiOrder,character-method}
\alias{$,ShojiOrder-method}
\alias{[<-,ShojiOrder,character,missing,ShojiOrder-method}
\alias{[<-,ShojiOrder,ANY,missing,ShojiOrder-method}
\alias{[[<-,ShojiOrder,character,missing,list-method}
\alias{[[<-,ShojiOrder,character,missing,character-method}
\alias{[[<-,ShojiOrder,character,missing,OrderGroup-method}
\alias{[[<-,ShojiOrder,ANY,missing,OrderGroup-method}
\alias{[[<-,ShojiOrder,ANY,missing,ANY-method}
\alias{[[<-,ShojiOrder,ANY,missing,NULL-method}
\alias{[[<-,ShojiOrder,character,missing,NULL-method}
\alias{[[<-,ShojiOrder,character,missing,ShojiOrder-method}
\alias{$<-,ShojiOrder-method}
\alias{[,OrderGroup,ANY,ANY-method}
\alias{[,OrderGroup,character,ANY-method}
\alias{[[,OrderGroup,character-method}
\alias{[[,OrderGroup,ANY-method}
\alias{$,OrderGroup-method}
\alias{[[<-,OrderGroup,character,missing,list-method}
\alias{[[<-,OrderGroup,character,missing,character-method}
\alias{[[<-,OrderGroup,character,missing,ShojiOrder-method}
\alias{[[<-,OrderGroup,character,missing,OrderGroup-method}
\alias{[[<-,OrderGroup,ANY,missing,OrderGroup-method}
\alias{[[<-,OrderGroup,numeric,missing,NULL-method}
\alias{[[<-,OrderGroup,character,missing,NULL-method}
\alias{$<-,OrderGroup-method}
\alias{[[,SlideCatalog,ANY-method}
\alias{[[<-,SlideCatalog,numeric,missing,CrunchSlide-method}
\alias{[[,CrunchSlide,ANY-method}
\alias{[[<-,CrunchSlide,ANY,ANY,ANY-method}
\alias{[[,AnalysisCatalog,ANY-method}
\alias{[[<-,AnalysisCatalog,numeric,missing,formula-method}
\alias{[[<-,AnalysisCatalog,numeric,missing,Analysis-method}
\alias{[[<-,AnalysisCatalog,numeric,missing,list-method}
\alias{[[,Subvariables,character-method}
\alias{[[,Subvariables,numeric-method}
\alias{[,Subvariables,character,ANY-method}
\alias{[[<-,Subvariables,character,missing,CrunchVariable-method}
\alias{[[<-,Subvariables,ANY,missing,CrunchVariable-method}
\alias{[[<-,Subvariables,ANY,missing,NULL-method}
\alias{[[<-,Subvariables,ANY,missing,ANY-method}
\alias{[<-,Subvariables,character,missing,Subvariables-method}
\alias{[<-,Subvariables,ANY,missing,Subvariables-method}
\alias{[<-,Subvariables,ANY,missing,ANY-method}
\alias{[,CategoricalArrayVariable,character,ANY-method}
\alias{[,CategoricalArrayVariable,missing,ANY-method}
\alias{[,CategoricalArrayVariable,missing,character-method}
\alias{[[,CategoricalArrayVariable,ANY-method}
\alias{[[,CategoricalArrayVariable,character-method}
\alias{$,CategoricalArrayVariable-method}
\alias{[[<-,CategoricalArrayVariable,ANY,missing,ANY-method}
\alias{[[<-,CategoricalArrayVariable,character,missing,ANY-method}
\alias{$<-,CategoricalArrayVariable-method}
\alias{[[,TabBookResult,numeric-method}
\alias{[[,TabBookResult,character-method}
\alias{[[,MultitableResult,ANY-method}
\alias{[[,TeamCatalog,numeric-method}
\alias{[[<-,TeamCatalog,character,missing,list-method}
\alias{[[<-,TeamCatalog,character,missing,CrunchTeam-method}
\alias{[,UserCatalog,character,ANY-method}
\alias{[[,UserCatalog,character-method}
\alias{[[,VariableCatalog,numeric-method}
\alias{[[<-,VariableCatalog,character,missing,VariableTuple-method}
\alias{[[<-,VariableCatalog,character,missing,CrunchVariable-method}
\alias{[,VariableCatalog,VariableOrder,ANY-method}
\alias{[,VariableCatalog,VariableGroup,ANY-method}
\alias{[<-,VariableCatalog,VariableOrder,missing,VariableCatalog-method}
\alias{[<-,VariableCatalog,VariableGroup,missing,VariableCatalog-method}
\alias{[[<-,VariableOrder,character,missing,CrunchDataset-method}
\alias{[[<-,VariableGroup,character,missing,CrunchDataset-method}
\alias{[<-,CrunchVariable,ANY,missing,ANY-method}
\alias{[<-,CrunchVariable,ANY,missing,NULL-method}
\alias{[<-,TextVariable,ANY,missing,character-method}
\alias{[<-,NumericVariable,ANY,missing,numeric-method}
\alias{[<-,DatetimeVariable,ANY,missing,Date-method}
\alias{[<-,DatetimeVariable,ANY,missing,POSIXt-method}
\alias{[<-,CrunchVariable,ANY,missing,CrunchExpr-method}
\alias{[<-,CrunchVariable,ANY,missing,CrunchVariable-method}
\alias{[<-,CrunchVariable,ANY,missing,CrunchLogicalExpr-method}
\alias{[<-,CategoricalVariable,ANY,missing,numeric-method}
\alias{[<-,CategoricalVariable,ANY,missing,character-method}
\alias{[<-,CategoricalVariable,ANY,missing,factor-method}
\alias{[<-,CategoricalArrayVariable,ANY,missing,numeric-method}
\alias{[<-,CategoricalArrayVariable,ANY,missing,character-method}
\alias{[<-,CategoricalArrayVariable,ANY,missing,factor-method}
\alias{[<-,CrunchVariable,ANY,missing,logical-method}
\alias{is.na<-,CrunchVariable,ANY-method}
\alias{[,CrunchVariable,CrunchExpr,ANY-method}
\alias{[,CrunchVariable,numeric,ANY-method}
\alias{[,CrunchVariable,logical,ANY-method}
\title{Extract and modify Crunch objects}
\usage{
\S4method{[}{AbstractCategories,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{AbstractCategories,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{AbstractCategories,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{AbstractCategories,character,ANY,ANY}(x, i, j, ...) <- value

\S4method{[[}{AbstractCategories,character}(x, i, j, ...)

\S4method{[[}{AbstractCategories,character,ANY,ANY}(x, i, j,
  ...) <- value

\S4method{$}{AbstractCategory}(x, name)

\S4method{$}{AbstractCategory}(x, name) <- value

\S4method{[}{Categories,ANY,ANY,ANY}(x, i, j, ...) <- value

\method{[}{CrunchDataFrame}(x, i, j, drop = TRUE)

\method{[}{CrunchDataFrame}(x, i, j) <- value

\method{[[}{CrunchDataFrame}(x, i)

\method{[[}{CrunchDataFrame}(x, i) <- value

\method{$}{CrunchDataFrame}(x, i)

\method{$}{CrunchDataFrame}(x, i) <- value

\S4method{[}{CubeDims,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CrunchCube,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{TransformsList,ANY,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{DatasetCatalog,numeric}(x, i, j, ...)

\S4method{[[}{DatasetCatalog,character,missing,DatasetTuple}(x, i,
  j) <- value

\S4method{[}{CrunchDataset,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CrunchDataset,logical,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{CrunchDataset,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CrunchDataset,VariableGroup,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CrunchDataset,VariableOrder,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CrunchDataset,missing,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{CrunchDataset,CrunchLogicalExpr,missing}(x, i, j, ...,
  drop = FALSE)

\S4method{[}{CrunchDataset,CrunchLogicalExpr,ANY}(x, i, j, ...,
  drop = FALSE)

\S4method{subset}{CrunchDataset}(x, ...)

\S4method{[[}{CrunchDataset,ANY}(x, i, ..., drop = FALSE)

\S4method{[[}{CrunchDataset,character}(x, i, ..., drop = FALSE)

\S4method{$}{CrunchDataset}(x, name)

\S4method{[[}{CrunchDataset,character,missing,CrunchVariable}(x,
  i) <- value

\S4method{[[}{CrunchDataset,ANY,missing,CrunchVariable}(x, i) <- value

\S4method{[[}{CrunchDataset,character,missing,ANY}(x, i) <- value

\S4method{[[}{CrunchDataset,character,missing,CrunchLogicalExpr}(x,
  i) <- value

\S4method{[[}{CrunchDataset,ANY,ANY,ANY}(x, i) <- value

\S4method{[[}{CrunchDataset,character,missing,`NULL`}(x, i) <- value

\S4method{[[}{CrunchDataset,ANY,missing,`NULL`}(x, i) <- value

\S4method{$}{CrunchDataset}(x, name) <- value

\S4method{[[}{CrunchDataset,character,missing,CrunchGeography}(x,
  i) <- value

\S4method{[[}{CrunchDataset,ANY,missing,CrunchGeography}(x, i) <- value

\S4method{[}{CrunchDataset,ANY,missing,list}(x, i, j) <- value

\S4method{[}{CrunchDataset,ANY,missing,CrunchDataset}(x, i, j) <- value

\S4method{[}{CrunchDataset,CrunchExpr,ANY,ANY}(x, i, j) <- value

\S4method{[}{ShojiCatalog,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ShojiCatalog,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ShojiCatalog,logical,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ShojiCatalog,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{ShojiCatalog,ANY}(x, i, j, ...)

\S4method{[[}{ShojiCatalog,character}(x, i, j, ...)

\S4method{$}{ShojiCatalog}(x, name)

\S4method{$}{ShojiCatalog}(x, name) <- value

\S4method{[}{ShojiCatalog,ANY,missing,ShojiCatalog}(x, i, j) <- value

\S4method{[[}{DeckCatalog,ANY}(x, i, j, ...)

\S4method{[[}{DeckCatalog,character}(x, i, j, ...)

\S4method{[[}{DeckCatalog,ANY,missing,CrunchDeck}(x, i, j) <- value

\S4method{[[}{CrunchDeck,ANY}(x, i, j, ...)

\S4method{[[}{CrunchDeck,ANY,ANY,ANY}(x, i, j) <- value

\S4method{[}{CrunchExpr,CrunchLogicalExpr,ANY}(x, i, j, ...,
  drop = FALSE)

\S4method{[}{CrunchExpr,logical,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CrunchExpr,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{FilterCatalog,numeric}(x, i, j, ...)

\S4method{[[}{FilterCatalog,character,missing,CrunchLogicalExpr}(x, i,
  j) <- value

\S4method{[[}{FilterCatalog,numeric,missing,CrunchLogicalExpr}(x, i,
  j) <- value

\S4method{[[}{FilterCatalog,character,missing,CrunchFilter}(x, i,
  j) <- value

\S4method{[[}{FilterCatalog,numeric,missing,CrunchFilter}(x, i,
  j) <- value

\S4method{[[}{MemberCatalog,character}(x, i, j, ...)

\S4method{[[}{MemberCatalog,ANY,missing,ANY}(x, i, j) <- value

\S4method{[[}{MemberCatalog,character,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{MultitableCatalog,numeric}(x, i, j, ...)

\S4method{[[}{MultitableCatalog,character,missing,formula}(x, i,
  j) <- value

\S4method{[[}{MultitableCatalog,numeric,missing,formula}(x, i,
  j) <- value

\S4method{[[}{MultitableCatalog,ANY,missing,Multitable}(x, i, j) <- value

\S4method{[[}{MultitableCatalog,ANY,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{PermissionCatalog,character}(x, i, j, ...)

\S4method{[[}{ProjectFolder,character,missing,list}(x, i, j) <- value

\S4method{[[}{ProjectFolder,character,missing,ProjectFolder}(x, i,
  j) <- value

\S4method{[[}{ShojiFolder,numeric}(x, i, ..., drop = FALSE)

\S4method{[[}{ShojiFolder,character}(x, i, ..., drop = FALSE)

\S4method{[}{ShojiOrder,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{ShojiOrder,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{ShojiOrder,ANY}(x, i, j, ...)

\S4method{[[}{ShojiOrder,character}(x, i, j, ...)

\S4method{$}{ShojiOrder}(x, name)

\S4method{[}{ShojiOrder,character,missing,ShojiOrder}(x, i, j) <- value

\S4method{[}{ShojiOrder,ANY,missing,ShojiOrder}(x, i, j) <- value

\S4method{[[}{ShojiOrder,character,missing,list}(x, i, j) <- value

\S4method{[[}{ShojiOrder,character,missing,character}(x, i, j) <- value

\S4method{[[}{ShojiOrder,character,missing,OrderGroup}(x, i, j) <- value

\S4method{[[}{ShojiOrder,ANY,missing,OrderGroup}(x, i, j) <- value

\S4method{[[}{ShojiOrder,ANY,missing,ANY}(x, i, j) <- value

\S4method{[[}{ShojiOrder,ANY,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{ShojiOrder,character,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{ShojiOrder,character,missing,ShojiOrder}(x, i, j) <- value

\S4method{$}{ShojiOrder}(x, name) <- value

\S4method{[}{OrderGroup,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{OrderGroup,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{OrderGroup,character}(x, i, j, ...)

\S4method{[[}{OrderGroup,ANY}(x, i, j, ...)

\S4method{$}{OrderGroup}(x, name)

\S4method{[[}{OrderGroup,character,missing,list}(x, i, j) <- value

\S4method{[[}{OrderGroup,character,missing,character}(x, i, j) <- value

\S4method{[[}{OrderGroup,character,missing,ShojiOrder}(x, i, j) <- value

\S4method{[[}{OrderGroup,character,missing,OrderGroup}(x, i, j) <- value

\S4method{[[}{OrderGroup,ANY,missing,OrderGroup}(x, i, j) <- value

\S4method{[[}{OrderGroup,numeric,missing,`NULL`}(x, i, j) <- value

\S4method{[[}{OrderGroup,character,missing,`NULL`}(x, i, j) <- value

\S4method{$}{OrderGroup}(x, name) <- value

\S4method{[[}{SlideCatalog,ANY}(x, i, j, ...)

\S4method{[[}{SlideCatalog,numeric,missing,CrunchSlide}(x, i, j) <- value

\S4method{[[}{CrunchSlide,ANY}(x, i, j, ...)

\S4method{[[}{CrunchSlide,ANY,ANY,ANY}(x, i, j) <- value

\S4method{[[}{AnalysisCatalog,ANY}(x, i, j, ...)

\S4method{[[}{AnalysisCatalog,numeric,missing,formula}(x, i, j) <- value

\S4method{[[}{AnalysisCatalog,numeric,missing,Analysis}(x, i, j) <- value

\S4method{[[}{AnalysisCatalog,numeric,missing,list}(x, i, j) <- value

\S4method{[[}{Subvariables,character}(x, i, j, ...)

\S4method{[[}{Subvariables,numeric}(x, i, j, ...)

\S4method{[}{Subvariables,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{Subvariables,character,missing,CrunchVariable}(x,
  i) <- value

\S4method{[[}{Subvariables,ANY,missing,CrunchVariable}(x, i) <- value

\S4method{[[}{Subvariables,ANY,missing,`NULL`}(x, i) <- value

\S4method{[[}{Subvariables,ANY,missing,ANY}(x, i) <- value

\S4method{[}{Subvariables,character,missing,Subvariables}(x, i) <- value

\S4method{[}{Subvariables,ANY,missing,Subvariables}(x, i) <- value

\S4method{[}{Subvariables,ANY,missing,ANY}(x, i) <- value

\S4method{[}{CategoricalArrayVariable,character,ANY}(x, i, j, ...,
  drop = TRUE)

\S4method{[}{CategoricalArrayVariable,missing,ANY}(x, i, j, ...,
  drop = TRUE)

\S4method{[}{CategoricalArrayVariable,missing,character}(x, i, j, ...,
  drop = TRUE)

\S4method{[[}{CategoricalArrayVariable,ANY}(x, i, j, ...)

\S4method{[[}{CategoricalArrayVariable,character}(x, i, j, ...)

\S4method{$}{CategoricalArrayVariable}(x, name)

\S4method{[[}{CategoricalArrayVariable,ANY,missing,ANY}(x, i) <- value

\S4method{[[}{CategoricalArrayVariable,character,missing,ANY}(x,
  i) <- value

\S4method{$}{CategoricalArrayVariable}(x, name) <- value

\S4method{[[}{TabBookResult,numeric}(x, i, j, ...)

\S4method{[[}{TabBookResult,character}(x, i, j, ...)

\S4method{[[}{MultitableResult,ANY}(x, i, j, ...)

\S4method{[[}{TeamCatalog,numeric}(x, i, j, ...)

\S4method{[[}{TeamCatalog,character,missing,list}(x, i, j) <- value

\S4method{[[}{TeamCatalog,character,missing,CrunchTeam}(x, i, j) <- value

\S4method{[}{UserCatalog,character,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[[}{UserCatalog,character}(x, i, j, ...)

\S4method{[[}{VariableCatalog,numeric}(x, i, j, ...)

\S4method{[[}{VariableCatalog,character,missing,VariableTuple}(x, i,
  j) <- value

\S4method{[[}{VariableCatalog,character,missing,CrunchVariable}(x, i,
  j) <- value

\S4method{[}{VariableCatalog,VariableOrder,ANY}(x, i, j, ...,
  drop = TRUE)

\S4method{[}{VariableCatalog,VariableGroup,ANY}(x, i, j, ...,
  drop = TRUE)

\S4method{[}{VariableCatalog,VariableOrder,missing,VariableCatalog}(x, i,
  j) <- value

\S4method{[}{VariableCatalog,VariableGroup,missing,VariableCatalog}(x, i,
  j) <- value

\S4method{[[}{VariableOrder,character,missing,CrunchDataset}(x, i,
  j) <- value

\S4method{[[}{VariableGroup,character,missing,CrunchDataset}(x, i,
  j) <- value

\S4method{[}{CrunchVariable,ANY,missing,ANY}(x, i, j) <- value

\S4method{[}{CrunchVariable,ANY,missing,`NULL`}(x, i, j) <- value

\S4method{[}{TextVariable,ANY,missing,character}(x, i, j) <- value

\S4method{[}{NumericVariable,ANY,missing,numeric}(x, i, j) <- value

\S4method{[}{DatetimeVariable,ANY,missing,Date}(x, i, j) <- value

\S4method{[}{DatetimeVariable,ANY,missing,POSIXt}(x, i, j) <- value

\S4method{[}{CrunchVariable,ANY,missing,CrunchExpr}(x, i, j) <- value

\S4method{[}{CrunchVariable,ANY,missing,CrunchVariable}(x, i, j) <- value

\S4method{[}{CrunchVariable,ANY,missing,CrunchLogicalExpr}(x, i,
  j) <- value

\S4method{[}{CategoricalVariable,ANY,missing,numeric}(x, i, j) <- value

\S4method{[}{CategoricalVariable,ANY,missing,character}(x, i, j) <- value

\S4method{[}{CategoricalVariable,ANY,missing,factor}(x, i, j) <- value

\S4method{[}{CategoricalArrayVariable,ANY,missing,numeric}(x, i,
  j) <- value

\S4method{[}{CategoricalArrayVariable,ANY,missing,character}(x, i,
  j) <- value

\S4method{[}{CategoricalArrayVariable,ANY,missing,factor}(x, i,
  j) <- value

\S4method{[}{CrunchVariable,ANY,missing,logical}(x, i, j) <- value

\S4method{is.na}{CrunchVariable,ANY}(x) <- value

\S4method{[}{CrunchVariable,CrunchExpr,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{CrunchVariable,numeric,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{CrunchVariable,logical,ANY}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{a Crunch object (Dataset, Variable, \code{CrunchExpr}, Catalog,
\code{CrunchCube}, etc.)}

\item{i}{The elements to extract; as with R, this can generally be (1) a
logical vector of length matching \code{x}; (2) a character vector of appropriate
length, which can generally be URLs or also names, aliases, or other
identifier; (3) integer indices, potentially negative, to select. Datasets
and Variables can also be subset by \code{CrunchExpr}. Note that when subsetting
Datasets and variables by R vectors, the input \code{i} is turned into a
\code{CrunchExpr} so that it can be used in API queries.}

\item{j}{For two-dimensional objects, elements to take from the columnar
dimension. Note that Datasets work like \code{data.frame}s in that you can extract
columns either by \code{ds[, j]} or by the list-like \code{ds[i]} (with no comma).}

\item{...}{additional arguments supported by some methods. For example, some
catalogs support a \code{secondary} vector of elements to match
against like \code{emails(x)} or \code{owners(x)}; by default this is \code{names(x)}. This
lets (for example) you to look up variables by URL but fall back to name.}

\item{drop}{Ignored and always assumed \code{FALSE}}

\item{value}{For updating, an object of the appropriate class and size to
insert. This is generally the same class of object you would get from the
extract method; i.e. for \code{x[[i]] <- value}, \code{value} must be the same class
as \code{x[[i]]}. Exceptions include \code{ds$var <- VariableDefinition(...)} to create
a new variable, and \code{ds$var[i] <- value}, which can take R vectors and
\code{CrunchExpr}.}

\item{name}{for \code{$}, the same as \code{i} for \code{[[}}
}
\value{
\code{[} generally returns a subset of \code{x}, same class and "self" URL;
when subsetting with a \code{CrunchExpr}, the expression is recorded in an
attribute of the object. \code{[[} and \code{$}
return appropriate extractions from \code{x}, wherever possible without making an
additional API request. The assignment methods return \code{x} appropriately
updated. Most assignment methods do not make an API request except where
they clearly are used to create a new entity (as in assigning a variable
definition to a Dataset); for editing metadata attributes, these methods
generally assume that the API request to set the changes on the server
happens in a different method (e.g. in \code{names(variables(ds)[1:5]) <- value},
assignment happens in the \code{names<-} method).
}
\description{
Extract and modify Crunch objects
}
\keyword{internal}
