% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{notifyIfNewVersion}
\alias{notifyIfNewVersion}
\alias{checkForNewVersion}
\title{See if there's a new version of the package on GitHub}
\usage{
notifyIfNewVersion(package = "crunch", github = "Crunch-io/rcrunch",
  installed.version = as.character(packageVersion(package)))

checkForNewVersion(github, installed.version)
}
\arguments{
\item{package}{character package name}

\item{github}{character "organization/repo" of your package on GitHub}

\item{installed.version}{character the currently installed version string}
}
\value{
\code{checkForNewVersion} returns the version string if there is a new
version, or NULL. \code{notifyIfNewVersion} returns nothing invisibly, called for
its side effects.
}
\description{
\code{checkForNewVersion} looks for a tagged version on GitHub and compares with
the version number of the currently installed package. \code{notifyIfNewVersion}
wraps it and displays a message if there is a new version. It is called in
\code{.onLoad()}.
}
\keyword{internal}
