% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_space.R
\name{expand_to_cell}
\alias{expand_to_cell}
\title{Expand content of asymmetric unit to whole unit cell}
\usage{
expand_to_cell(sdata, SG = NULL)
}
\arguments{
\item{sdata}{A named list, normally obtained through the use of
function \code{\link{read_x}}. The list names correspond to 
different object types:
\itemize{
  \item{a.     Real numeric. The size of the unit cell.}
  \item{SG.    Character string. Space group symbol; either "P1" 
               or "P-1"}
  \item{x0.    Vector of real numerics indicating the expanded atomic
               positions in the unit cell.}
  \item{Z.     Vector of integers indicating the expanded 
               atomic numbers for all atoms in the unit cell.}
  \item{B.    Vector of real numerics indicating the expanded 
              B factors for all atoms in the unit cell.}
  \item{occ.  Vector of real numerics indicating the expanded 
              occupancies for all atoms in the unit cell.}
}}

\item{SG}{2-letters character string. There are only two symmetries
possible when working within 1D crystallography, P1 (no symmetry)
and P-1 (inversion through the origin). SG can be either "P1" or
"P-1" for this function. Default is NULL, in which case the space
group is assumed to be equal to the one of the input structure.}
}
\value{
A named list with the following elements:
 \itemize{
   \item{a.   Real numeric. The size of the unit cell.}
   \item{SG.  Character string. Name of the space group, either "P1"
              or "P-1".}
   \item{x0. Vector of real numerics indicating the expanded atomic
               positions in the unit cell.}
   \item{Z.  Vector of integers indicating the expanded atomic numbers
               for all atoms in the unit cell.}
   \item{B.  Vector of real numerics indicating the expanded B factors
               for all atoms in the unit cell.}
   \item{occ. Vector of real numerics indicating the expanded occupancies
                 for all atoms in the unit cell.}
 }
}
\description{
Atom positions, types, B factors and occupancies are duplicated if
input space group (SG) is P-1; otherwise they are left untouched
(space group P1). Value of the occupancy for special positions is
barely checked for values outside [0,1] range. Extra-care needed.
}
\examples{
# Asymmetric unit includes 3 atoms between 0 and a/2
a <- 10
SG <- "P-1"
x0 <- c(1,2,4)
Z <- c(6,8,6)
B <- c(1,1.2,1.1)
occ <- c(1,1,0.8)
sdata <- standardise_sdata(a,SG,x0,Z,B,occ)
ltmp <- expand_to_cell(sdata)
print(ltmp)  # Positions, atomic numbers, etc. have doubled

# Nothing changes if imposed SG is "P1" (but you get a warning!)
ltmp <- expand_to_cell(sdata,SG="P1")
print(ltmp)
}
