% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller.R
\name{crew_class_controller}
\alias{crew_class_controller}
\title{Controller class}
\description{
\code{R6} class for controllers.
}
\details{
See \code{\link[=crew_controller]{crew_controller()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
launcher <- crew_launcher_local()
controller <- crew_controller(client = client, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}

## ------------------------------------------------
## Method `crew_class_controller$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
launcher <- crew_launcher_local()
controller <- crew_controller(client = client, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\seealso{
Other class: 
\code{\link{crew_class_client}},
\code{\link{crew_class_controller_group}},
\code{\link{crew_class_launcher}},
\code{\link{crew_class_schedule}}
}
\concept{class}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{client}}{Router object.}

\item{\code{launcher}}{Launcher object.}

\item{\code{schedule}}{Schedule object.}

\item{\code{log}}{Tibble with per-worker metadata about tasks.}

\item{\code{until}}{Numeric of length 1, time point when
throttled auto-scaling unlocks.}

\item{\code{error}}{Tibble of monads from the last call to
\verb{map(error = "stop)}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller-new}{\code{crew_class_controller$new()}}
\item \href{#method-crew_class_controller-validate}{\code{crew_class_controller$validate()}}
\item \href{#method-crew_class_controller-empty}{\code{crew_class_controller$empty()}}
\item \href{#method-crew_class_controller-nonempty}{\code{crew_class_controller$nonempty()}}
\item \href{#method-crew_class_controller-saturated}{\code{crew_class_controller$saturated()}}
\item \href{#method-crew_class_controller-start}{\code{crew_class_controller$start()}}
\item \href{#method-crew_class_controller-launch}{\code{crew_class_controller$launch()}}
\item \href{#method-crew_class_controller-scale}{\code{crew_class_controller$scale()}}
\item \href{#method-crew_class_controller-push}{\code{crew_class_controller$push()}}
\item \href{#method-crew_class_controller-shove}{\code{crew_class_controller$shove()}}
\item \href{#method-crew_class_controller-map}{\code{crew_class_controller$map()}}
\item \href{#method-crew_class_controller-collect}{\code{crew_class_controller$collect()}}
\item \href{#method-crew_class_controller-pop}{\code{crew_class_controller$pop()}}
\item \href{#method-crew_class_controller-wait}{\code{crew_class_controller$wait()}}
\item \href{#method-crew_class_controller-summary}{\code{crew_class_controller$summary()}}
\item \href{#method-crew_class_controller-terminate}{\code{crew_class_controller$terminate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-new}{}}}
\subsection{Method \code{new()}}{
\code{mirai} controller constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$new(client = NULL, launcher = NULL, schedule = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{client}}{Router object. See \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{launcher}}{Launcher object. See \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{schedule}}{Schedule object from \code{\link[=crew_schedule]{crew_schedule()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} controller object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
client <- crew_client()
launcher <- crew_launcher_local()
controller <- crew_controller(client = client, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-empty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-empty}{}}}
\subsection{Method \code{empty()}}{
Check if the controller is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$empty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if the controller is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-nonempty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-nonempty}{}}}
\subsection{Method \code{nonempty()}}{
Check if the controller is nonempty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$nonempty(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is empty if it has no running tasks
or completed tasks waiting to be retrieved with \code{push()}.
}

\subsection{Returns}{
\code{TRUE} if the controller is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-saturated"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-saturated}{}}}
\subsection{Method \code{saturated()}}{
Check if the controller is saturated.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$saturated(
  collect = TRUE,
  throttle = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collect}}{Logical of length 1, whether to collect the results
of any newly resolved tasks before determining saturation.}

\item{\code{throttle}}{Logical of length 1, whether to delay task collection
until the next request at least \code{self$client$seconds_interval}
seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
A controller is saturated if the number of unresolved tasks
is greater than or equal to the maximum number of workers.
In other words, in a saturated controller, every available worker
has a task.
You can still push tasks to a saturated controller, but
tools that use \code{crew} such as \code{targets} may choose not to.
}

\subsection{Returns}{
\code{TRUE} if the controller is saturated, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-start}{}}}
\subsection{Method \code{start()}}{
Start the controller if it is not already started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Register the mirai client and register worker websockets
with the launcher.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to try to launch. The actual
number launched is capped so that no more than "\code{workers}"
workers running at a given time, where "\code{workers}"
is an argument of \code{\link[=crew_controller]{crew_controller()}}. The
actual cap is the "\code{workers}" argument minus the number of connected
workers minus the number of starting workers. A "connected"
worker has an active websocket connection to the \code{mirai} client,
and "starting" means that the worker was launched at most
\code{seconds_start} seconds ago, where \code{seconds_start} is
also an argument of \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-scale}{}}}
\subsection{Method \code{scale()}}{
Auto-scale workers out to meet the demand of tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$scale(throttle = FALSE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{Logical of length 1, whether to delay auto-scaling
until the next auto-scaling request at least
\code{self$client$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Methods \code{push()}, \code{pop()}, and \code{wait()} already invoke
\code{scale()} if the \code{scale} argument is \code{TRUE}.
For finer control of the number of workers launched,
call \code{launch()} on the controller with the exact desired
number of workers.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$push(
  command,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = as.integer(nanonext::random()/2),
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  scale = TRUE,
  throttle = TRUE,
  name = NA_character_,
  save_command = FALSE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task.
This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument
of \code{\link[=crew_controller_local]{crew_controller_local()}}.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{scale}}{Logical, whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
By design, auto-scaling might not actually happen
if \code{throttle = TRUE}.}

\item{\code{throttle}}{If \code{scale} is \code{TRUE}, whether to defer auto-scaling
until the next request at least
\code{self$client$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{name}}{Optional name of the task.}

\item{\code{save_command}}{Logical of length 1. If \code{TRUE}, the controller
deparses the command and returns it with the output on \code{pop()}.
If \code{FALSE} (default), the controller skips this step to
increase speed.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-shove"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-shove}{}}}
\subsection{Method \code{shove()}}{
Quickly push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$shove(
  command,
  data = list(),
  globals = list(),
  seed = 0L,
  packages = character(0),
  library = NULL,
  .timeout = NULL,
  name = NA_character_,
  string = NA_character_
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task.
This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument
of \code{\link[=crew_controller_local]{crew_controller_local()}}.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to set for the evaluation of the task.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{.timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{name}}{Optional name of the task.}

\item{\code{string}}{Optional character string with the deparsed command.}

\item{\code{scale}}{Logical, whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
By design, auto-scaling might not actually happen
if \code{throttle = TRUE}.}

\item{\code{throttle}}{If \code{scale} is \code{TRUE}, whether to defer auto-scaling
until the next request at least
\code{self$client$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Exists to support extensions to \code{crew} for \code{purrr}-like
functional programming. For developers only and not supported for
controller groups. Relative to \code{push()}, \code{shove()} skips user
options and guardrails for to aggressively optimize performance.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-map"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-map}{}}}
\subsection{Method \code{map()}}{
Apply a single command to multiple inputs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$map(
  command,
  iterate,
  data = list(),
  globals = list(),
  substitute = TRUE,
  seed = as.integer(nanonext::random()/2),
  packages = character(0),
  library = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  names = NULL,
  save_command = FALSE,
  error = "stop",
  verbose = interactive(),
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{iterate}}{Named list of vectors or lists to iterate over.
For example, to run function calls
\code{f(x = 1, y = "a")} and \code{f(x = 2, y = "b")},
set \code{command} to \code{f(x, y)}, and set \code{iterate} to
\code{list(x = c(1, 2), y = c("a", "b"))}. The individual
function calls are evaluated as
\code{f(x = iterate$x[[1]], y = iterate$y[[1]])} and
\code{f(x = iterate$x[[2]], y = iterate$y[[2]])}.
All the elements of \code{iterate} must have the same length.
If there are any name conflicts between \code{iterate} and \code{data},
\code{iterate} takes precedence.}

\item{\code{data}}{Named list of constant local data objects in the
evaluation environment. Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{globals}}{Named list of constant objects to temporarily
assign to the global environment for each task. This list should
include any functions you previously defined in the global
environment which are required to run tasks.
See the \code{reset_globals} argument of \code{\link[=crew_controller_local]{crew_controller_local()}}.
Objects in this list are treated as single
values and are held constant for each iteration of the map.}

\item{\code{substitute}}{Logical of length 1, whether to call
\code{base::substitute()} on the supplied value of the
\code{command} argument. If \code{TRUE} (default) then \code{command} is quoted
literally as you write it, e.g.
\code{push(command = your_function_call())}. If \code{FALSE}, then \code{crew}
assumes \code{command} is a language object and you are passing its
value, e.g. \code{push(command = quote(your_function_call()))}.
\code{substitute = TRUE} is appropriate for interactive use,
whereas \code{substitute = FALSE} is meant for automated R programs
that invoke \code{crew} controllers.}

\item{\code{seed}}{Integer of length 1 with a pseudo-random number generator
seed. Task-specific task seeds are non-randomly derived
from this seed.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_interval}}{Number of seconds to wait between intervals
polling the tasks for completion. Defaults to the \code{seconds_interval}
field in the client object}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{names}}{Optional character of length 1, name of the element of
\code{iterate} with names for the tasks. If \code{names} is supplied,
then \code{iterate[[names]]} must be a character vector.}

\item{\code{save_command}}{Logical of length 1, whether to store
a text string version of the R command in the output.}

\item{\code{error}}{Character vector of length 1, choice of action if
a task has an error. Possible values:
\itemize{
\item \code{"stop"}: throw an error in the main R session instead of returning
a value. In case of an error, the results from the last errored
\code{map()} are in the \code{error} field
of the controller, e.g. \code{controller_object$error}. To reduce
memory consumption, set \code{controller_object$error <- NULL} after
you are finished troubleshooting.
\item \code{"warn"}: throw a warning. This allows the return value with
all the error messages and tracebacks to be generated.
\item \code{"silent"}: do nothing special.
}}

\item{\code{verbose}}{Logical of length 1, whether to print progress messages.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The idea comes from functional programming: for example,
the \code{map()} function from the \code{purrr} package.
The controller must be started and empty before calling \code{map()}.
}

\subsection{Returns}{
A \code{tibble} of results and metadata, like the output of \code{pop()}
but with multiple rows aggregated together (one row per task).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-collect}{}}}
\subsection{Method \code{collect()}}{
Check for done tasks and move the results to
the results list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$collect(throttle = FALSE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{throttle}}{whether to defer task collection
until the next task collection request at least
\code{seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly). Removes elements from the \code{queue}
list as applicable and moves them to the \code{results} list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a completed task from the results data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$pop(
  scale = TRUE,
  collect = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical of length 1,
whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
Auto-scaling might not actually happen if \code{throttle} is \code{TRUE}.
Scaling up on \code{pop()} may be important
for transient or nearly transient workers that tend to drop off
quickly after doing little work.}

\item{\code{collect}}{Logical of length 1,
whether to collect the results of completed tasks.}

\item{\code{throttle}}{Whether to defer auto-scaling and task collection
until the next request at least
\code{self$client$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If not task is currently completed and collected, \code{pop()}
will attempt to auto-scale workers as needed and collect
any newly completed results.
}

\subsection{Returns}{
If there is a completed task available to collect, the return
value is a one-row data frame with the results, warnings, and errors.
Otherwise, if there are no results available to collect,
the return value is \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-wait}{}}}
\subsection{Method \code{wait()}}{
Wait for tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$wait(
  mode = "all",
  seconds_interval = NULL,
  seconds_timeout = Inf,
  scale = TRUE,
  throttle = TRUE,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{If \code{mode} is \code{"all"},
then the method waits for all tasks to complete. If \code{mode} is
\code{"one"}, then it waits until a one task is complete.}

\item{\code{seconds_interval}}{Number of seconds to wait between polling
intervals waiting for tasks. Defaults to the \code{seconds_interval}
field of the client object.}

\item{\code{seconds_timeout}}{Timeout length in seconds waiting for tasks.}

\item{\code{scale}}{Logical, whether to automatically call \code{scale()}
to auto-scale workers to meet the demand of the task load.
Might not actually auto-scale on every iteration if \code{throttle}
is \code{TRUE}.}

\item{\code{throttle}}{Whether to defer auto-scaling
and task collection until the next request at least
\code{self$client$seconds_interval} seconds from the original request.
The idea is similar to \code{shiny::throttle()} except that \code{crew} does not
accumulate a backlog of requests. The technique improves robustness
and efficiency.
Highly recommended
to keep \code{throttle = TRUE} in \code{wait()} to ensure efficiency
and robustness.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{wait()} method blocks the calling R session,
repeatedly auto-scales workers for tasks
that need them, and repeatedly collects results.
The function runs until it either times out or reaches
its stopping condition based on the \code{mode} argument.
}

\subsection{Returns}{
\code{NULL} (invisibly). Call \code{pop()} to get the result.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers and tasks of the controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$summary(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of summary statistics on the workers and tasks.
It has one row per worker websocket and the following columns:
\itemize{
\item \code{controller}: name of the controller.
.  * \code{worker}: integer index of the worker.
\item \code{tasks}: number of tasks which were completed by
a worker at the websocket and then returned by calling
\code{pop()} on the controller object.
\item \code{seconds}: total number of runtime and seconds of
all the tasks that ran on a worker connected to this websocket
and then were retrieved by calling \code{pop()} on the controller
object.
\item \code{errors}: total number of tasks which ran on a worker
at the website, encountered an error in R, and then retrieved
with \code{pop()}.
\item \code{warnings}: total number of tasks which ran on a worker
at the website, encountered one or more warnings in R,
and then retrieved with \code{pop()}. Note: \code{warnings}
is actually the number of \emph{tasks}, not the number of warnings.
(A task could throw more than one warning.
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the workers and the \code{mirai} client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$terminate(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
