% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbGetTaxonID.R
\name{getTaxonID}
\alias{getTaxonID}
\title{Extract taxonID(s) corresponding to the taxonomic description}
\usage{
getTaxonID(
  family = "",
  genus = "",
  species = "",
  taxaType = 1,
  dbname = "gbif4crest_02"
)
}
\arguments{
\item{family}{The name of the family.}

\item{genus}{The name of the genus.}

\item{species}{The name of the species.}

\item{taxaType}{A numerical index (between 1 and 6) to define the type of
palaeoproxy used: 1 for plants, 2 for beetles, 3 for chironomids,
4 for foraminifers, 5 for diatoms and 6 for rodents. The example
dataset uses taxaType=0 (pseudo-data). Default is 1.}

\item{dbname}{The name of the data source database.}
}
\value{
A vector of unique taxonIDs.
}
\description{
Extract all possible TaxonIDs corresponding to the provided taxonomical
description, which can be at the family, the genus or the species levels.
}
\examples{
\dontrun{
  getTaxonID("Zamiaceae")
  getTaxonID("Zamiaceae", "Ceratozamia")
  ## \code{taxaType = 2} searches for beetles and not plants, so the next line returns nothing.
  getTaxonID("Zamiaceae", "Ceratozamia", taxaType = 2)
}

}
