% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable_binning.R
\name{split_bins_all}
\alias{split_bins_all}
\title{Split bins all}
\usage{
split_bins_all(
  dat,
  x_list = NULL,
  ex_cols = NULL,
  breaks_list = NULL,
  bins_no = TRUE,
  note = FALSE,
  save_data = FALSE,
  file_name = NULL,
  dir_path = tempdir(),
  ...
)
}
\arguments{
\item{dat}{A data.frame with independent variables.}

\item{x_list}{A list of x variables.}

\item{ex_cols}{Names of excluded variables. Regular expressions can also be used to match variable names. Default is NULL.}

\item{breaks_list}{A list contains breaks of variables. it is generated by code{\link{get_breaks_all}},code{\link{get_breaks}}}

\item{bins_no}{Number the generated bins. Default is TRUE.}

\item{note}{Logical, outputs info. Default is TRUE.}

\item{save_data}{Logical, save results in locally specified folder. Default is TRUE}

\item{file_name}{The name for periodically saved woe file. Default is "dat_woe".}

\item{dir_path}{The path for periodically saved woe file Default is "./data"}

\item{...}{Additional parameters.}
}
\value{
A data.frame with splitted bins.
}
\description{
\code{split_bins} is for transforming data to bins.
The \code{split_bins_all} function is a simpler wrapper for \code{split_bins}.
}
\examples{
sub = cv_split(UCICreditCard, k = 30)[[1]]
dat = UCICreditCard[sub,]
dat = re_name(dat, "default.payment.next.month", "target")
dat = data_cleansing(dat, target = "target", obs_id = "ID", occur_time = "apply_date",
miss_values =  list("", -1))

train_test = train_test_split(dat, split_type = "OOT", prop = 0.7,
                                occur_time = "apply_date")
dat_train = train_test$train
dat_test = train_test$test
#get breaks of all predictive variables
x_list = c("PAY_0", "LIMIT_BAL", "PAY_AMT5", "EDUCATION", "PAY_3", "PAY_2")
breaks_list = get_breaks_all(dat = dat_train, target = "target",
                              x_list = x_list, occur_time = "apply_date", ex_cols = "ID",
save_data = FALSE, note  = FALSE)
#woe transform
train_bins = split_bins_all(dat = dat_train,
                          breaks_list = breaks_list,
                          woe_name = FALSE)
test_bins = split_bins_all(dat = dat_test,
                         breaks_list = breaks_list,
                         note = FALSE)

}
\seealso{
\code{\link{get_tree_breaks}}, \code{\link{cut_equal}}, \code{\link{select_best_class}}, \code{\link{select_best_breaks}}
}
