% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_anaylsis.R
\name{check_rules}
\alias{check_rules}
\title{check_rules}
\usage{
check_rules(rules_list, test_dat, target)
}
\arguments{
\item{rules_list}{A lift of rules.}

\item{test_dat}{A data.frame of test.}

\item{target}{The name of target variable.}
}
\value{
A data frame with tree rules and percent under each rule.
}
\description{
\code{get_ctree_rules} This function is used to parse party ctree rules and percentage of 1 under each rule.
}
\examples{
train_test <- train_test_split(UCICreditCard, split_type = "Random", prop = 0.8, save_data = FALSE)
dat_train = train_test$train
dat_test = train_test$test
dat_train$default.payment.next.month = as.numeric(dat_train$default.payment.next.month)
rules_list = get_ctree_rules(tree_fit = NULL, train_dat = dat_train[, 8:26],
                             target ="default.payment.next.month", test_dat = dat_test)[1:3,2]
check_rules(rules_list = rules_list, target = "default.payment.next.month", test_dat = dat_test)

}
